/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.cache.impl.metrics.CacheManagerMetricEmitter;
import com.atlassian.confluence.cache.CacheCompactor;
import com.atlassian.confluence.cache.ConfluenceManagedCache;
import com.atlassian.confluence.cache.NoopClusterCacheCompactor;
import com.atlassian.confluence.cache.ehcache.ConfluenceEhCache;
import com.atlassian.confluence.cache.ehcache.DefaultConfluenceEhCache;
import com.atlassian.confluence.cache.ehcache.EhCacheCompactor;
import com.atlassian.confluence.impl.cache.LocalCacheImplementation;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.SizeOfPolicyConfiguration;
import org.checkerframework.checker.nullness.qual.NonNull;

public class EhCacheManager
implements CacheManager {
    private final Set<String> cachedReferenceNames = Collections.synchronizedSet(new HashSet());
    private final ResettableLazyReference<CacheManager> delegateRef;
    private final ResettableLazyReference<net.sf.ehcache.CacheManager> ehCacheInstanceRef = Lazy.resettable(() -> {
        LocalCacheImplementation.assertImplementation((LocalCacheImplementation)LocalCacheImplementation.EHCACHE);
        return net.sf.ehcache.CacheManager.create((Configuration)EhCacheManager.getDefaultCacheConfig(cacheSettingsDefaultsProvider));
    });

    public EhCacheManager(CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider) {
        this.delegateRef = Lazy.resettable(() -> new com.atlassian.cache.ehcache.EhCacheManager(this.getDelegateEhCacheManager(), null, cacheSettingsDefaultsProvider));
    }

    static Configuration getDefaultCacheConfig(CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider) {
        CacheSettings defaultCacheSettings = cacheSettingsDefaultsProvider.getDefaults("default");
        return new Configuration().defaultCache(new CacheConfiguration("defaultCache", defaultCacheSettings.getMaxEntries().intValue()).timeToIdleSeconds(defaultCacheSettings.getExpireAfterAccess().longValue()).timeToLiveSeconds(defaultCacheSettings.getExpireAfterWrite().longValue()).maxEntriesLocalHeap(defaultCacheSettings.getMaxEntries().intValue()).eternal(false).sizeOfPolicy(new SizeOfPolicyConfiguration().maxDepth(32).maxDepthExceededBehavior(SizeOfPolicyConfiguration.MaxDepthExceededBehavior.ABORT)));
    }

    @PreDestroy
    public void shutdownCacheManager() {
        if (this.ehCacheInstanceRef.isInitialized()) {
            ((net.sf.ehcache.CacheManager)this.ehCacheInstanceRef.get()).shutdown();
        }
    }

    public void flushCaches() {
        String[] cacheNames = this.getDelegateEhCacheManager().getCacheNames();
        this.emitFlushCachesMetric();
        ImmutableSet allNonFlushableCacheNames = ImmutableSet.builder().addAll(Iterables.transform((Iterable)Iterables.filter((Iterable)this.delegate().getManagedCaches(), (Predicate)Predicates.not(this.flushable())), this.cacheName())).build();
        for (String cacheName : cacheNames) {
            if (allNonFlushableCacheNames.contains(cacheName)) continue;
            this.getDelegateEhCacheManager().getEhcache(cacheName).removeAll();
        }
    }

    private void emitFlushCachesMetric() {
        new CacheManagerMetricEmitter().emitCacheManagerFlushAll(this.getClass().getName());
    }

    private Predicate<ManagedCache> flushable() {
        return ManagedCache::isFlushable;
    }

    private Function<ManagedCache, String> cacheName() {
        return ManagedCache::getName;
    }

    net.sf.ehcache.CacheManager getDelegateEhCacheManager() {
        return (net.sf.ehcache.CacheManager)this.ehCacheInstanceRef.get();
    }

    CacheManager delegate() {
        return (CacheManager)this.delegateRef.get();
    }

    @Deprecated
    public @NonNull Collection<Cache<?, ?>> getCaches() {
        ArrayList ret = new ArrayList();
        for (String cacheName : this.getDelegateEhCacheManager().getCacheNames()) {
            if (this.cachedReferenceNames.contains(cacheName)) continue;
            ret.add((Cache<?, ?>)this.getCache(cacheName));
        }
        return ret;
    }

    private <K, V> ConfluenceEhCache<K, V> wrapCache(Cache<K, V> cache) {
        Ehcache ehCache = this.getDelegateEhCacheManager().getEhcache(cache.getName());
        CacheConfiguration ehCacheConfig = ehCache.getCacheConfiguration();
        return new DefaultConfluenceEhCache<K, V>(cache, ehCacheConfig);
    }

    public <K, V> @NonNull ConfluenceEhCache<K, V> getCache(@NonNull String name) {
        return this.wrapCache(this.delegate().getCache(name));
    }

    @Deprecated
    public <K, V> @NonNull Cache<K, V> getCache(@NonNull String name, @NonNull Class<K> keyType, @NonNull Class<V> valueType) {
        return this.wrapCache(this.delegate().getCache(name, keyType, valueType));
    }

    public @NonNull Collection<ManagedCache> getManagedCaches() {
        Collection managedCaches = Collections2.filter((Collection)this.delegate().getManagedCaches(), EhCacheManager.notACachedReference());
        return Collections2.transform((Collection)managedCaches, cache -> cache == null ? null : new ConfluenceManagedCache(cache, cache.isFlushable()));
    }

    private static Predicate<ManagedCache> notACachedReference() {
        return input -> !(input instanceof CachedReference);
    }

    public ManagedCache getManagedCache(@NonNull String name) {
        ManagedCache mc = this.delegate().getManagedCache(name);
        return null == mc ? null : new ConfluenceManagedCache(mc, mc.isFlushable());
    }

    public void shutdown() {
        if (this.delegateRef.isInitialized()) {
            ((CacheManager)this.delegateRef.get()).shutdown();
        }
    }

    public <V> @NonNull CachedReference<V> getCachedReference(@NonNull String name, @NonNull Supplier<V> supplier) {
        CachedReference result = this.delegate().getCachedReference(name, supplier);
        this.cachedReferenceNames.add(name);
        return result;
    }

    public <V> @NonNull CachedReference<V> getCachedReference(@NonNull String name, @NonNull Supplier<V> supplier, @NonNull CacheSettings settings) {
        CachedReference result = this.delegate().getCachedReference(name, supplier, settings);
        this.cachedReferenceNames.add(name);
        return result;
    }

    public <V> @NonNull CachedReference<V> getCachedReference(@NonNull Class<?> owningClass, @NonNull String fieldName, @NonNull Supplier<V> supplier) {
        String fullName = this.toName(owningClass, fieldName);
        CachedReference result = this.delegate().getCachedReference(fullName, supplier);
        this.cachedReferenceNames.add(fullName);
        return result;
    }

    public <V> @NonNull CachedReference<V> getCachedReference(@NonNull Class<?> owningClass, @NonNull String fieldName, @NonNull Supplier<V> supplier, @NonNull CacheSettings settings) {
        String fullName = this.toName(owningClass, fieldName);
        CachedReference result = this.delegate().getCachedReference(fullName, supplier, settings);
        this.cachedReferenceNames.add(fullName);
        return result;
    }

    public <K, V> @NonNull Cache<K, V> getCache(@NonNull Class<?> owningClass, @NonNull String name) {
        return this.wrapCache(this.delegate().getCache(owningClass, name));
    }

    public <K, V> @NonNull Cache<K, V> getCache(@NonNull String name, CacheLoader<K, V> loader) {
        return this.wrapCache(this.delegate().getCache(name, loader));
    }

    public <K, V> @NonNull ConfluenceEhCache<K, V> getCache(@NonNull String name, CacheLoader<K, V> loader, @NonNull CacheSettings settings) {
        return this.wrapCache(this.delegate().getCache(name, loader, settings));
    }

    public net.sf.ehcache.CacheManager getEhCacheManager() {
        return this.getDelegateEhCacheManager();
    }

    private String toName(Class<?> owningClass, String fieldName) {
        return owningClass.getName() + "." + (String)Preconditions.checkNotNull((Object)fieldName);
    }

    CacheCompactor getCacheCompactor() {
        return switch (LocalCacheImplementation.get()) {
            case LocalCacheImplementation.EHCACHE -> new EhCacheCompactor(this.ehCacheInstanceRef);
            default -> new NoopClusterCacheCompactor();
        };
    }
}

