/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.easyuser;

import com.atlassian.confluence.event.events.user.SendUserInviteEvent;
import com.atlassian.confluence.plugins.easyuser.UserInvites;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.SignupManager;
import com.atlassian.confluence.user.notifications.NotificationSendResult;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.user.User;
import com.google.errorprone.annotations.Immutable;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;

@Path(value="/")
@AdminOnly
public class EasyUserResource {
    private final SignupManager easyUserManager;

    @Inject
    public EasyUserResource(@ComponentImport SignupManager easyUserManager) {
        this.easyUserManager = easyUserManager;
    }

    @POST
    @Path(value="refreshToken")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response newInviteUrl() {
        this.easyUserManager.refreshAndGetToken();
        return this.okResponseWithSignupUrl();
    }

    @POST
    @Path(value="sendUserInvites")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendUserInvites(UserInvites userInvites) {
        SendUserInviteEvent event = userInvites.buildEvent(this, (User)AuthenticatedUserThreadLocal.get());
        NotificationSendResult result = this.easyUserManager.sendInvites(event);
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="undoTokenReset")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response undoTokenReset() {
        this.easyUserManager.restorePreviousToken();
        return this.okResponseWithSignupUrl();
    }

    private Response okResponseWithSignupUrl() {
        return Response.ok((Object)new Result(this.easyUserManager.getSignupURL(), this.easyUserManager.isEmailSentOnInviteSignUp())).build();
    }

    @XmlRootElement
    @Immutable
    static class Result {
        @XmlElement
        private final String signupUrl;
        @XmlElement
        private final boolean notifyAdmin;

        public Result() {
            this.signupUrl = null;
            this.notifyAdmin = false;
        }

        public Result(String signupUrl, boolean notifyAdmin) {
            this.signupUrl = signupUrl;
            this.notifyAdmin = notifyAdmin;
        }

        public String getSignupUrl() {
            return this.signupUrl;
        }

        public boolean isNotifyAdmin() {
            return this.notifyAdmin;
        }
    }
}

