/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.easyuser;

import com.atlassian.confluence.plugins.easyuser.SignupSettingsBean;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.SignupManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.net.InternetDomainName;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="signup")
public class EasyUserSignupSettingsResource {
    private final PermissionManager permissionManager;
    private final SignupManager easyUserManager;

    @Inject
    public EasyUserSignupSettingsResource(@ComponentImport PermissionManager permissionManager, @ComponentImport SignupManager easyUserManager) {
        this.permissionManager = permissionManager;
        this.easyUserManager = easyUserManager;
    }

    @POST
    @Path(value="setSignupSettings")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setSignupSettings(SignupSettingsBean settings) {
        boolean enabled = settings.isEnabled();
        String domains = settings.getDomains();
        boolean notify = settings.isNotifyAdmin();
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (!enabled) {
            if (!StringUtils.isEmpty((CharSequence)domains)) {
                for (String domainString : Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)",; ")).omitEmptyStrings().trimResults().split((CharSequence)domains)) {
                    if (InternetDomainName.isValid((String)domainString)) continue;
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The domains parameter should contain valid internet domains names separated by commas (,)").build();
                }
                this.easyUserManager.setDomainRestrictedSignupMode(domains);
            } else {
                this.easyUserManager.setPrivateSignupMode();
            }
        } else {
            this.easyUserManager.setPublicSignupMode();
        }
        this.easyUserManager.setEmailSentOnInviteSignUp(notify);
        return Response.ok().build();
    }
}

