/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.filter;

import com.atlassian.confluence.plugins.mobile.MobileUtils;
import com.atlassian.confluence.plugins.mobile.event.MobileLoginEvent;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class CanUseFilter
extends HttpFilter {
    private final PermissionManager permissionManager;
    private final EventPublisher eventPublisher;
    private String redirectLocation;

    public CanUseFilter(PermissionManager permissionManager, EventPublisher eventPublisher) {
        this.permissionManager = permissionManager;
        this.eventPublisher = eventPublisher;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.redirectLocation = filterConfig.getInitParameter("loginRedirectLocation");
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ConfluenceUser remoteUser;
        if (MobileUtils.isMobileViewRequest(request) && !this.permissionManager.hasPermission(remoteUser = AuthenticatedUserThreadLocal.get(), Permission.VIEW, PermissionManager.TARGET_APPLICATION)) {
            if (remoteUser == null) {
                response.sendRedirect(this.createLoginUrl(request));
            } else {
                response.sendError(403, "Not permitted to use the application.");
            }
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String createLoginUrl(HttpServletRequest request) {
        this.eventPublisher.publish((Object)new MobileLoginEvent(request));
        String originalPath = request.getRequestURI().substring(request.getContextPath().length());
        String originalUrl = originalPath + (String)(StringUtils.isNotBlank((CharSequence)request.getQueryString()) ? "?" + request.getQueryString() : "");
        return request.getContextPath() + this.redirectLocation + "?os_destination=" + URLEncoder.encode(originalUrl, StandardCharsets.UTF_8);
    }
}

