/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.plugins.mobile.MobileUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
public class RedirectFilter
extends HttpFilter {
    private String redirectLocation;
    private String skipParameter;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.redirectLocation = filterConfig.getInitParameter("redirectLocation");
        this.skipParameter = filterConfig.getInitParameter("skipFilteringParameterName");
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean skipFilter;
        String skipParamValue = this.skipParameter != null ? request.getParameter(this.skipParameter) : null;
        boolean bl = skipFilter = StringUtils.isNotBlank((CharSequence)skipParamValue) && Boolean.parseBoolean(skipParamValue);
        if (!skipFilter && MobileUtils.isMobileViewRequest(request)) {
            response.sendRedirect(request.getContextPath() + this.redirectLocation + (String)(StringUtils.isNotBlank((CharSequence)request.getQueryString()) ? "?" + request.getQueryString() : ""));
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

