/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.render;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.plugins.mobile.event.MobileUnsupportedMacroEvent;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.confluence.web.UrlBuilder;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.event.api.EventPublisher;
import jakarta.servlet.http.HttpServletRequest;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;

public class NonMobileMacroPlaceholder {
    private final TemplateRenderer templateRenderer;
    private final EventPublisher eventPublisher;
    private final HttpContext httpContext;

    public NonMobileMacroPlaceholder(TemplateRenderer templateRenderer, EventPublisher eventPublisher, HttpContext httpContext) {
        this.templateRenderer = templateRenderer;
        this.eventPublisher = eventPublisher;
        this.httpContext = httpContext;
    }

    public String create(String macroName, Macro macro, ConversionContext context) {
        ContentEntityObject entity = this.getOriginalEntity(context);
        UrlBuilder builder = new UrlBuilder(entity.getUrlPath());
        builder.add("desktop", true);
        builder.add("macroName", macroName);
        Map<String, Object> data = Collections.singletonMap("desktopUrl", builder.toUrl());
        StringWriter writer = new StringWriter();
        if (macro.getOutputType() == Macro.OutputType.INLINE) {
            this.createInline(writer, data);
        } else {
            this.createBlock(writer, data);
        }
        this.publishAnalyticEvent(entity.getId(), macroName);
        return writer.toString();
    }

    private void publishAnalyticEvent(Long contentId, String macroName) {
        HttpServletRequest req = this.httpContext.getActiveRequest();
        if (req == null) {
            return;
        }
        this.eventPublisher.publish((Object)new MobileUnsupportedMacroEvent(req, contentId, macroName, "web"));
    }

    private void createInline(Appendable appendable, Map<String, Object> data) {
        this.templateRenderer.renderTo(appendable, "com.atlassian.confluence.plugins.confluence-mobile:view-content-resources", "Confluence.Templates.Mobile.Macros.inlineNonMobilePlaceholder.soy", data);
    }

    private void createBlock(Appendable appendable, Map<String, Object> data) {
        this.templateRenderer.renderTo(appendable, "com.atlassian.confluence.plugins.confluence-mobile:view-content-resources", "Confluence.Templates.Mobile.Macros.blockNonMobilePlaceholder.soy", data);
    }

    private ContentEntityObject getOriginalEntity(ConversionContext context) {
        PageContext pageContext = context.getPageContext();
        if (pageContext != null) {
            while (pageContext.getOriginalContext() != pageContext) {
                pageContext = pageContext.getOriginalContext();
            }
            return pageContext.getEntity();
        }
        return context.getEntity();
    }
}

