/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostViewEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.mobile.dto.CommentDto;
import com.atlassian.confluence.plugins.mobile.dto.CommentDtoFactory;
import com.atlassian.confluence.plugins.mobile.dto.WebResourceDependenciesDto;
import com.atlassian.confluence.plugins.mobile.dto.WebResourceDependenciesDtoFactory;
import com.atlassian.confluence.plugins.mobile.rest.ContentResourceInterface;
import com.atlassian.confluence.plugins.mobile.rest.model.ContentDto;
import com.atlassian.confluence.plugins.mobile.rest.model.ContentDtoFactory;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/content")
public class ContentResource
implements ContentResourceInterface {
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final CommentDtoFactory commentDtoFactory;
    private final ContentDtoFactory contentDtoFactory;
    private final WebResourceDependenciesDtoFactory webResourceDependenciesDtoFactory;
    private final TransactionTemplate transactionTemplate;
    private final EventPublisher eventPublisher;

    @Inject
    public ContentResource(@Qualifier(value="pageManager") PageManager pageManager, PermissionManager permissionManager, CommentDtoFactory commentDtoFactory, ContentDtoFactory contentDtoFactory, WebResourceDependenciesDtoFactory webResourceDependenciesDtoFactory, TransactionTemplate transactionTemplate, EventPublisher eventPublisher) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.commentDtoFactory = commentDtoFactory;
        this.contentDtoFactory = contentDtoFactory;
        this.webResourceDependenciesDtoFactory = webResourceDependenciesDtoFactory;
        this.transactionTemplate = transactionTemplate;
        this.eventPublisher = eventPublisher;
    }

    @Override
    @GET
    @Path(value="/{id}")
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public ContentDto getContent(@PathParam(value="id") Long contentId, @QueryParam(value="knownResources") String knownResources, @QueryParam(value="knownContexts") String knownContexts) {
        return this.performContentOperation(contentId, (ContentEntityObject ceo) -> {
            ContentDto dto = this.contentDtoFactory.getContentDto(ceo);
            WebResourceDependenciesDto dependenciesDto = this.webResourceDependenciesDtoFactory.getWebResourceDependenciesDto(knownResources, knownContexts);
            dto.setWebResourceDependencies(dependenciesDto);
            return dto;
        });
    }

    @Override
    @GET
    @Path(value="/page/{spaceKey}/{title}/")
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public ContentDto getContent(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="title") String title, @QueryParam(value="knownResources") String knownResources, @QueryParam(value="knownContexts") String knownContexts) {
        return this.performPageOperation(spaceKey, title, ceo -> {
            ContentDto dto = this.contentDtoFactory.getContentDto(ceo);
            WebResourceDependenciesDto dependenciesDto = this.webResourceDependenciesDtoFactory.getWebResourceDependenciesDto(knownResources, knownContexts);
            dto.setWebResourceDependencies(dependenciesDto);
            return dto;
        });
    }

    @Override
    @GET
    @Path(value="/blogpost/{spaceKey}/{year}/{month}/{day}/{title}/")
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public ContentDto getContent(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="title") String title, @PathParam(value="year") int year, @PathParam(value="month") int month, @PathParam(value="day") int day, @QueryParam(value="knownResources") String knownResources, @QueryParam(value="knownContexts") String knownContexts) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day);
        return this.performBlogPostOperation(spaceKey, title, cal, ceo -> {
            ContentDto dto = this.contentDtoFactory.getContentDto(ceo);
            WebResourceDependenciesDto dependenciesDto = this.webResourceDependenciesDtoFactory.getWebResourceDependenciesDto(knownResources, knownContexts);
            dto.setWebResourceDependencies(dependenciesDto);
            return dto;
        });
    }

    @Override
    @GET
    @Path(value="/{id}/comments")
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public List<CommentDto> getComments(@PathParam(value="id") Long contentId, @QueryParam(value="knownResources") Set<String> knownResources, @QueryParam(value="knownContexts") Set<String> knownContexts) {
        return this.performContentOperation(contentId, (ContentEntityObject ceo) -> {
            List comments = ceo.getComments();
            ArrayList<CommentDto> commentDtos = new ArrayList<CommentDto>(comments.size());
            for (Comment comment : comments) {
                commentDtos.add(this.commentDtoFactory.getCommentDto(comment));
            }
            return commentDtos;
        });
    }

    private <T> T performContentOperation(Long contentId, ContentOperation<T> operation) {
        return (T)this.transactionTemplate.execute(() -> this.performContentOperation(this.pageManager.getById(contentId.longValue()), operation));
    }

    private <T> T performPageOperation(String spaceKey, String title, ContentOperation<T> operation) {
        return (T)this.transactionTemplate.execute(() -> this.performContentOperation((ContentEntityObject)this.pageManager.getPageWithComments(spaceKey, title), operation));
    }

    private <T> T performBlogPostOperation(String spaceKey, String title, Calendar day, ContentOperation<T> operation) {
        return (T)this.transactionTemplate.execute(() -> this.performContentOperation((ContentEntityObject)this.pageManager.getBlogPost(spaceKey, title, day, true), operation));
    }

    private <T> T performContentOperation(ContentEntityObject contentEntity, ContentOperation<T> operation) {
        T result;
        if (contentEntity == null || contentEntity.isDeleted()) {
            this.throwNotFoundResponse();
        }
        if (contentEntity != null) {
            contentEntity = (ContentEntityObject)contentEntity.getLatestVersion();
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)contentEntity)) {
            this.throwNotFoundResponse();
        }
        if ((result = operation.perform(contentEntity)) != null) {
            PageViewEvent event = null;
            if (contentEntity instanceof Page) {
                event = new PageViewEvent((Object)this, (Page)contentEntity);
            } else if (contentEntity instanceof BlogPost) {
                event = new BlogPostViewEvent((Object)this, (BlogPost)contentEntity);
            }
            this.eventPublisher.publish((Object)event);
        }
        return result;
    }

    private void throwNotFoundResponse() {
        if (AuthenticatedUserThreadLocal.get() == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    private static interface ContentOperation<T> {
        public T perform(ContentEntityObject var1);
    }
}

