/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.mobile.AnonymousUserSupport;
import com.atlassian.confluence.plugins.mobile.rest.ProfileResourceInterface;
import com.atlassian.confluence.plugins.rest.jackson2.dto.UserDto;
import com.atlassian.confluence.plugins.rest.jackson2.dto.UserDtoFactory;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;

@Path(value="/profile")
public class ProfileResource
implements ProfileResourceInterface {
    private final UserDtoFactory userDtoFactory;
    private final UserAccessor userAccessor;
    private final AnonymousUserSupport anonymousUserSupport;

    @Inject
    public ProfileResource(UserDtoFactory userDtoFactory, UserAccessor userAccessor, AnonymousUserSupport anonymousUserSupport) {
        this.userDtoFactory = userDtoFactory;
        this.userAccessor = userAccessor;
        this.anonymousUserSupport = anonymousUserSupport;
    }

    @Override
    @GET
    @Path(value="/{username}")
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public UserDto getProfile(@PathParam(value="username") String username) {
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        if (user == null || !this.anonymousUserSupport.isProfileViewPermitted()) {
            this.throwNotFoundResponse();
        }
        return this.userDtoFactory.getUserDto(user);
    }

    private void throwNotFoundResponse() {
        if (AuthenticatedUserThreadLocal.isAnonymousUser()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }
}

