/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.webresource;

import com.atlassian.confluence.plugins.mobile.MobileUtils;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplaySwitchToMobileCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(DisplaySwitchToMobileCondition.class);
    private final HttpContext httpContext;

    public DisplaySwitchToMobileCondition(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        HttpServletRequest request = this.httpContext.getActiveRequest();
        if (request == null) {
            log.warn("No servlet request retrieved so defaulting to not serving 'switch to mobile' resources");
            return false;
        }
        return MobileUtils.isSupportedUserAgent(request) && MobileUtils.isDesktopSwitchRequired(request);
    }
}

