/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.webresource;

import com.atlassian.confluence.plugins.mobile.MobileUtils;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.condition.UrlReadingCondition;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplaySwitchToMobileUrlReadingCondition
implements UrlReadingCondition {
    private static final Logger log = LoggerFactory.getLogger(DisplaySwitchToMobileUrlReadingCondition.class);
    private static final String QUERY_PARAM = "ismobile";
    private final HttpContext httpContext;

    public DisplaySwitchToMobileUrlReadingCondition(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        boolean isMobile;
        HttpServletRequest request = this.httpContext.getActiveRequest();
        if (request == null) {
            log.warn("No servlet request retrieved so defaulting to not serving 'switch to mobile' resources");
            return;
        }
        boolean bl = isMobile = MobileUtils.isSupportedUserAgent(request) && MobileUtils.isDesktopSwitchRequired(request);
        if (isMobile) {
            urlBuilder.addToQueryString(QUERY_PARAM, String.valueOf(true));
        }
    }

    public boolean shouldDisplay(QueryParams queryParams) {
        String isMobile = queryParams.get(QUERY_PARAM);
        if (!StringUtils.isEmpty((CharSequence)isMobile)) {
            return Boolean.parseBoolean(isMobile);
        }
        return false;
    }
}

