/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.webresource;

import com.atlassian.confluence.plugin.webresource.WebResourceDispatcher;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.servlet.DownloadStrategy;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class MobilePluginResourceDownload
implements DownloadStrategy {
    static final String MATCHES_SUBSTRING = "/plugins/servlet/mobile/download";
    private final WebResourceDispatcher webResourceDispatcher;

    public MobilePluginResourceDownload(WebResourceDispatcher webResourceDispatcher) {
        this.webResourceDispatcher = webResourceDispatcher;
    }

    public boolean matches(String url) {
        return url.contains(MATCHES_SUBSTRING) && this.webResourceDispatcher.canDispatch(this.modifyUrl(url));
    }

    public void serveFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            String url = this.modifyUrl(URLDecoder.decode(httpServletRequest.getRequestURI(), GeneralUtil.getCharacterEncoding()));
            this.webResourceDispatcher.dispatch(httpServletRequest, url, httpServletResponse);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String modifyUrl(String url) {
        return url.replace(MATCHES_SUBSTRING, "/download");
    }
}

