/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.alias;

import com.atlassian.crowd.dao.alias.AliasDAO;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.alias.Alias;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5.CrowdCriteriaBatchedInClauseHelperBuilder;
import com.atlassian.hibernate.extras.batching.CriteriaBatchedInClauseHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

public class AliasDAOHibernate
extends HibernateDao<Alias>
implements AliasDAO {
    private static final CriteriaBatchedInClauseHelper<Alias> ALIASES_FOR_USERS = CrowdCriteriaBatchedInClauseHelperBuilder.of(Alias.class).withParameter("lowerName").build();
    private HQLQueryTranslater hqlQueryTranslater;

    public String findAliasByUsername(Application application, String username) {
        return this.findAliasObjectByUsername(application, username).map(Alias::getAlias).orElse(null);
    }

    public List<Alias> findAll() {
        return this.findAllInternal();
    }

    public String findUsernameByAlias(Application application, String alias) {
        return this.findAliasObjectByAlias(application, alias).map(Alias::getName).orElse(null);
    }

    @Override
    public Class<Alias> getPersistentClass() {
        return Alias.class;
    }

    public void removeAlias(Application application, String username) {
        this.findAliasObjectByUsername(application, username).ifPresent(this::remove);
    }

    public void removeAliases(Application application) {
        this.session().getNamedQuery("removeAllAliasesForApplication").setParameter("applicationId", (Object)application.getId()).executeUpdate();
    }

    public List<String> search(EntityQuery<String> entityQuery) {
        Validate.isTrue((entityQuery.getEntityDescriptor().getEntityType() == Entity.ALIAS ? 1 : 0) != 0, (String)"AliasDAO can only evaluate EntityQueries for Entity.ALIAS", (Object[])new Object[0]);
        return this.executeHQLQuery(this.hqlQueryTranslater.asHQL(entityQuery));
    }

    public void storeAlias(Application application, String username, String alias) {
        Validate.notNull((Object)application, (String)"Application cannot be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)username), (String)"Username cannot be blank", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)alias), (String)"Alias cannot be blank", (Object[])new Object[0]);
        Alias aliasObject = this.findAliasObjectByUsername(application, username).orElseGet(() -> new Alias(application, username, alias));
        aliasObject.setAlias(alias);
        this.saveOrUpdate(aliasObject);
    }

    public List<Alias> findAliasesForUsers(Application application, Iterable<String> userNames) {
        Iterable lowercaseUserNames = Iterables.transform(userNames, IdentifierUtils.TO_LOWER_CASE::apply);
        return ALIASES_FOR_USERS.executeAndCollect(this.session(), lowercaseUserNames, criteria -> criteria.add((Criterion)Restrictions.eq((String)"application.id", (Object)application.getId())));
    }

    public Map<String, String> findAllAliases(Application application) {
        List results = this.session().createQuery("select name, alias from Alias where application.id = :id", Object[].class).setParameter("id", (Object)application.getId()).list();
        return results.stream().collect(Collectors.toMap(e -> (String)e[0], e -> (String)e[1]));
    }

    public void removeAliasesForUser(String username) {
        this.session().getNamedQuery("removeAllAliasesForUser").setString("username", username).executeUpdate();
    }

    private Optional<Alias> findAliasObjectByAlias(Application application, String alias) {
        return this.findByPropertiesOptional((Map<String, Object>)ImmutableMap.of((Object)"application.id", (Object)application.getId(), (Object)"lowerAlias", (Object)IdentifierUtils.toLowerCase((String)alias)));
    }

    private Optional<Alias> findAliasObjectByUsername(Application application, String username) {
        return this.findByPropertiesOptional((Map<String, Object>)ImmutableMap.of((Object)"application.id", (Object)application.getId(), (Object)"lowerName", (Object)IdentifierUtils.toLowerCase((String)username)));
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }
}

