/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.application;

import com.atlassian.crowd.dao.alias.AliasDAO;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.application.ApplicationDefaultGroupMembershipConfigurationDao;
import com.atlassian.crowd.dao.licensing.LicensingSummaryDao;
import com.atlassian.crowd.dao.permission.InternalUserPermissionDAO;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryMappingNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDirectoryMapping;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class ApplicationDAOHibernate
extends HibernateDao<ApplicationImpl>
implements ApplicationDAO {
    private AliasDAO aliasDao;
    private DirectoryDao directoryDao;
    private InternalUserPermissionDAO userPermissionDAO;
    private HQLQueryTranslater hqlQueryTranslater;
    private ApplicationDefaultGroupMembershipConfigurationDao applicationDefaultGroupMembershipConfigurationDao;
    private LicensingSummaryDao licensingSummaryDao;

    public ApplicationImpl add(Application application, PasswordCredential passwordCredential) {
        ApplicationImpl internalApplication = ApplicationImpl.newInstance((Application)application);
        internalApplication.setCredential(passwordCredential);
        internalApplication.setCreatedDateToNow();
        internalApplication.setUpdatedDateToNow();
        internalApplication.setAttribute("atlassian_sha1_applied", Boolean.TRUE.toString());
        internalApplication.validate();
        super.save(internalApplication);
        return internalApplication;
    }

    public void addDirectoryMapping(long applicationId, long directoryId, boolean allowAllToAuthenticate, OperationType ... operationTypes) throws DirectoryNotFoundException, ApplicationNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        Directory directory = this.directoryDao.findById(directoryId);
        application.addDirectoryMapping(directory, allowAllToAuthenticate, operationTypes);
        this.updateInternal(application);
    }

    public void addGroupMapping(long applicationId, long directoryId, String groupName) throws ApplicationNotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)groupName));
        ApplicationImpl application = this.findById(applicationId);
        application.addGroupMapping(directoryId, groupName);
        this.updateInternal(application);
    }

    public void addRemoteAddress(long applicationId, RemoteAddress remoteAddress) throws ApplicationNotFoundException {
        Validate.notNull((Object)remoteAddress);
        ApplicationImpl application = this.findById(applicationId);
        application.addRemoteAddress(remoteAddress.getAddress());
        this.updateInternal(application);
    }

    public List<Application> findAuthorisedApplications(long directoryId, List<String> groupNames) {
        if (groupNames == null || groupNames.isEmpty()) {
            return this.session().getNamedQuery("findAuthorisedApplicationsWithoutGroupNames").setLong("directoryId", directoryId).list();
        }
        return this.session().getNamedQuery("findAuthorisedApplications").setLong("directoryId", directoryId).setParameterList("groupNames", groupNames).list();
    }

    public ApplicationImpl findById(long id) throws ApplicationNotFoundException {
        return (ApplicationImpl)this.load(id, ApplicationNotFoundException::new);
    }

    public ApplicationImpl findByName(String name) throws ApplicationNotFoundException {
        return (ApplicationImpl)this.findByProperty("lowerName", IdentifierUtils.toLowerCase((String)name), ApplicationNotFoundException::new);
    }

    @Override
    public Class<ApplicationImpl> getPersistentClass() {
        return ApplicationImpl.class;
    }

    public void remove(Application application) {
        ApplicationImpl appImpl;
        try {
            appImpl = this.findById(application.getId());
        }
        catch (ApplicationNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        this.licensingSummaryDao.removeByApplicationId(application.getId());
        this.aliasDao.removeAliases(application);
        ImmutableList.copyOf((Collection)application.getDirectoryMappings()).forEach(directoryMapping -> this.removeDirectoryMappingInternal(appImpl, directoryMapping.getDirectory().getId()));
        super.remove(appImpl);
    }

    public void removeDirectoryMapping(long applicationId, long directoryId) throws ApplicationNotFoundException {
        this.removeDirectoryMappingInternal(this.findById(applicationId), directoryId);
    }

    public void removeDirectoryMappings(long directoryId) {
        List applications = this.session().getNamedQuery("findApplicationsWithDirectoryMapping").setLong("directoryId", directoryId).list();
        applications.forEach(application -> this.removeDirectoryMappingInternal((ApplicationImpl)application, directoryId));
    }

    private void removeDirectoryMappingInternal(ApplicationImpl application, long directoryId) {
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        Set groupMappings = directoryMapping.getAuthorisedGroups();
        this.removeDefaultGroupMemberships(application, directoryMapping);
        ImmutableList.copyOf((Collection)groupMappings).forEach(this::removeGroupMappingInternal);
        this.userPermissionDAO.revokeAll(directoryMapping);
        application.removeDirectoryMapping(directoryId);
        this.updateInternal(application);
    }

    private void removeDefaultGroupMemberships(ApplicationImpl application, DirectoryMapping directoryMapping) {
        try {
            this.applicationDefaultGroupMembershipConfigurationDao.removeAll((Application)application, (ApplicationDirectoryMapping)directoryMapping);
        }
        catch (ApplicationNotFoundException | DirectoryMappingNotFoundException throwable) {
            // empty catch block
        }
    }

    public void removeGroupMapping(long applicationId, long directoryId, String groupName) throws ApplicationNotFoundException {
        this.removeGroupMappingInternal(this.findById(applicationId), directoryId, groupName);
    }

    private void removeGroupMappingInternal(ApplicationImpl application, long directoryId, String groupName) {
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        GroupMapping groupMapping = directoryMapping.getGroupMapping(groupName);
        if (groupMapping != null) {
            this.removeGroupMappingInternal(groupMapping);
            application.setUpdatedDateToNow();
        }
    }

    public void removeGroupMappings(long directoryId, String groupName) {
        this.findAuthorisedApplications(directoryId, Collections.singletonList(groupName)).forEach(application -> {
            ApplicationImpl app = (ApplicationImpl)this.session().get(ApplicationImpl.class, (Serializable)application.getId());
            this.removeGroupMappingInternal(app, directoryId, groupName);
        });
    }

    private void removeGroupMappingInternal(GroupMapping groupMapping) {
        DirectoryMapping directoryMapping = groupMapping.getDirectoryMapping();
        directoryMapping.removeGroupMapping(groupMapping.getGroupName());
        super.update(directoryMapping);
    }

    public void removeRemoteAddress(long applicationId, RemoteAddress remoteAddress) throws ApplicationNotFoundException {
        Validate.notNull((Object)remoteAddress);
        ApplicationImpl application = this.findById(applicationId);
        application.removeRemoteAddress(remoteAddress.getAddress());
        this.updateInternal(application);
    }

    public List<Application> search(EntityQuery<Application> query) {
        Validate.isTrue((query.getEntityDescriptor().getEntityType() == Entity.APPLICATION ? 1 : 0) != 0, (String)"ApplicationDAO can only evaluate EntityQueries for Entity.APPLICATION", (Object[])new Object[0]);
        return this.executeHQLQuery(this.hqlQueryTranslater.asHQL(query));
    }

    public ApplicationImpl update(Application application) throws ApplicationNotFoundException {
        ApplicationImpl internalApplication = this.findById(application.getId());
        internalApplication.updateDetailsFromApplication(application);
        internalApplication.validate();
        this.updateInternal(internalApplication);
        return internalApplication;
    }

    public void updateCredential(Application application, PasswordCredential passwordCredential) throws ApplicationNotFoundException {
        if (!passwordCredential.isEncryptedCredential()) {
            throw new IllegalArgumentException("The application password needs to be encrypted before being updated");
        }
        ApplicationImpl internalApplication = this.findByName(application.getName());
        internalApplication.setCredential(passwordCredential);
        internalApplication.setAttribute("atlassian_sha1_applied", Boolean.TRUE.toString());
        this.updateInternal(internalApplication);
    }

    public void updateDirectoryMapping(long applicationId, long directoryId, int position) throws ApplicationNotFoundException, DirectoryNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        List directoryMappings = application.getDirectoryMappings();
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        if (directoryMapping == null) {
            throw new DirectoryNotFoundException(Long.valueOf(directoryId));
        }
        int currentIndex = directoryMappings.indexOf(directoryMapping);
        if (currentIndex >= 0 && position >= 0 && position < directoryMappings.size()) {
            DirectoryMapping directoryMappingToMove = (DirectoryMapping)directoryMappings.remove(currentIndex);
            directoryMappings.add(position, directoryMappingToMove);
            this.updateInternal(application);
        }
    }

    public void updateDirectoryMapping(long applicationId, long directoryId, boolean allowAllToAuthenticate) throws ApplicationNotFoundException, DirectoryNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        if (directoryMapping == null) {
            throw new DirectoryNotFoundException(Long.valueOf(directoryId));
        }
        directoryMapping.setAllowAllToAuthenticate(allowAllToAuthenticate);
        this.updateInternal(application);
    }

    public void updateDirectoryMapping(long applicationId, long directoryId, boolean allowAllToAuthenticate, Set<OperationType> operationTypes) throws ApplicationNotFoundException, DirectoryNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        if (directoryMapping == null) {
            throw new DirectoryNotFoundException(Long.valueOf(directoryId));
        }
        directoryMapping.setAllowAllToAuthenticate(allowAllToAuthenticate);
        directoryMapping.setAllowedOperations(operationTypes);
        application.setUpdatedDateToNow();
    }

    protected void updateInternal(ApplicationImpl application) {
        application.setUpdatedDateToNow();
        super.update(application);
    }

    public DirectoryMapping findDirectoryMapping(long applicationId, long directoryId) throws DirectoryMappingNotFoundException {
        Optional maybeDirectoryMapping = this.session().getNamedQuery("findDirectoryMapping").setLong("applicationId", applicationId).setLong("directoryId", directoryId).uniqueResultOptional();
        return (DirectoryMapping)maybeDirectoryMapping.orElseThrow(() -> new DirectoryMappingNotFoundException(applicationId, directoryId));
    }

    @Autowired
    public void setAliasDao(AliasDAO aliasDao) {
        this.aliasDao = aliasDao;
    }

    @Autowired
    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }

    @Autowired
    public void setUserPermissionDAO(InternalUserPermissionDAO userPermissionDAO) {
        this.userPermissionDAO = userPermissionDAO;
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    @Autowired
    public void setApplicationDefaultGroupMembershipConfigurationDao(ApplicationDefaultGroupMembershipConfigurationDao applicationDefaultGroupMembershipConfigurationDao) {
        this.applicationDefaultGroupMembershipConfigurationDao = applicationDefaultGroupMembershipConfigurationDao;
    }

    @Autowired
    public void setLicensingSummaryDao(LicensingSummaryDao licensingSummaryDao) {
        this.licensingSummaryDao = licensingSummaryDao;
    }
}

