/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.application;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.application.ApplicationDefaultGroupMembershipConfigurationDao;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryMappingNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDirectoryMapping;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.InternalApplicationDefaultGroupMembershipConfiguration;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ApplicationDefaultGroupMembershipConfigurationDaoHibernate
extends HibernateDao
implements ApplicationDefaultGroupMembershipConfigurationDao {
    private ApplicationDAO applicationDAO;

    public void add(Application application, ApplicationDirectoryMapping directoryMapping, String groupName) throws DirectoryMappingNotFoundException, ApplicationNotFoundException {
        DirectoryMapping directoryMappingEntity = this.applicationDAO.findDirectoryMapping(application.getId().longValue(), directoryMapping.getDirectory().getId().longValue());
        InternalApplicationDefaultGroupMembershipConfiguration configuration = new InternalApplicationDefaultGroupMembershipConfiguration(directoryMappingEntity, groupName);
        super.save(configuration);
    }

    public void remove(Application application, ApplicationDirectoryMapping directoryMapping, String groupName) throws DirectoryMappingNotFoundException, ApplicationNotFoundException {
        DirectoryMapping directoryMappingEntity = this.applicationDAO.findDirectoryMapping(application.getId().longValue(), directoryMapping.getDirectory().getId().longValue());
        this.session().getNamedQuery("removeDefaultGroupMembershipConfiguration").setLong("directoryMappingId", directoryMappingEntity.getId().longValue()).setString("groupName", groupName).executeUpdate();
    }

    public void removeAll(Application application, ApplicationDirectoryMapping directoryMapping) throws DirectoryMappingNotFoundException, ApplicationNotFoundException {
        DirectoryMapping directoryMappingEntity = this.applicationDAO.findDirectoryMapping(application.getId().longValue(), directoryMapping.getDirectory().getId().longValue());
        this.session().getNamedQuery("removeAllDefaultGroupMembershipsForApplicationAndDirectory").setLong("directoryMappingId", directoryMappingEntity.getId().longValue()).executeUpdate();
    }

    public List<InternalApplicationDefaultGroupMembershipConfiguration> listAll(Application application, ApplicationDirectoryMapping directoryMapping) throws DirectoryMappingNotFoundException, ApplicationNotFoundException {
        DirectoryMapping directoryMappingEntity = this.applicationDAO.findDirectoryMapping(application.getId().longValue(), directoryMapping.getDirectory().getId().longValue());
        return this.session().getNamedQuery("listAllAutoAddGroupConfigurations").setLong("directoryMappingId", directoryMappingEntity.getId().longValue()).list();
    }

    @Autowired
    public void setApplicationDAO(ApplicationDAO applicationDAO) {
        this.applicationDAO = applicationDAO;
    }

    public Class<?> getPersistentClass() {
        return InternalApplicationDefaultGroupMembershipConfiguration.class;
    }
}

