/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.audit.processor.impl;

import com.atlassian.crowd.audit.AuditLogAuthor;
import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.AuditLogEntityType;
import com.atlassian.crowd.audit.AuditLogEntry;
import com.atlassian.crowd.audit.AuditLogEventType;
import com.atlassian.crowd.audit.ImmutableAuditLogChangeset;
import com.atlassian.crowd.audit.ImmutableAuditLogEntity;
import com.atlassian.crowd.dao.audit.AuditDao;
import com.atlassian.crowd.dao.audit.processor.GroupAuditProcessor;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.audit.AuditLogChangesetPopulator;
import com.atlassian.crowd.manager.audit.AuditLogMetadataResolver;
import com.atlassian.crowd.manager.audit.mapper.AuditLogGroupMapper;
import com.atlassian.crowd.model.audit.AuditLogChangesetEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.util.persistence.hibernate.batch.BulkAuditMapper;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGroupAuditProcessor
implements GroupAuditProcessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultGroupAuditProcessor.class);
    private final DirectoryDao directoryDao;
    private final AuditDao auditDao;
    private final AuditLogChangesetPopulator auditLogChangesetPopulator;
    private final AuditLogGroupMapper auditLogGroupMapper;
    private final AuditLogMetadataResolver auditLogMetadataResolver;

    public DefaultGroupAuditProcessor(DirectoryDao directoryDao, AuditDao auditDao, AuditLogChangesetPopulator auditLogChangesetPopulator, AuditLogGroupMapper auditLogGroupMapper, AuditLogMetadataResolver auditLogMetadataResolver) {
        this.directoryDao = directoryDao;
        this.auditDao = auditDao;
        this.auditLogChangesetPopulator = auditLogChangesetPopulator;
        this.auditLogGroupMapper = auditLogGroupMapper;
        this.auditLogMetadataResolver = auditLogMetadataResolver;
    }

    @Override
    public void auditGroupAdded(InternalGroup group) {
        this.auditGroupOperation(AuditLogEventType.GROUP_CREATED, group, this.auditLogGroupMapper.calculateDifference(null, (Group)group));
    }

    @Override
    public void auditGroupUpdated(Group previous, InternalGroup updated) {
        this.auditGroupOperation(AuditLogEventType.GROUP_UPDATED, updated, this.auditLogGroupMapper.calculateDifference(previous, (Group)updated));
    }

    private void auditGroupOperation(AuditLogEventType eventType, InternalGroup group, List<AuditLogEntry> diffEntries) {
        if (diffEntries.isEmpty()) {
            log.debug("Omitting empty group changeset for event {} with group '{}'", (Object)eventType, (Object)group.getName());
            return;
        }
        AuditLogChangeset auditLogChangeset = this.prepareAuditLogChangeset(eventType, group, group.getDirectory(), diffEntries);
        this.auditDao.add(new AuditLogChangesetEntity(this.populateChangeset(auditLogChangeset)));
    }

    @Override
    public void auditGroupRemoved(InternalGroup group) {
        this.auditGroupOperation(AuditLogEventType.GROUP_DELETED, group, this.auditLogGroupMapper.calculateDifference((Group)group, null));
    }

    @Override
    public BulkAuditMapper<TransactionGroup<InternalGroup, Serializable>> auditBulkAddGroups() {
        AuditLogAuthor auditLogAuthor = this.auditLogMetadataResolver.resolveAuthor();
        return transactionGroups -> transactionGroups.stream().map(TransactionGroup::getPrimaryObject).map(group -> {
            AuditLogChangeset auditLogChangeset = this.prepareAuditLogChangeset(AuditLogEventType.GROUP_DELETED, (InternalGroup)group, this.getDirectory((InternalGroup)group), this.auditLogGroupMapper.calculateDifference((Group)group, null));
            ImmutableAuditLogChangeset changeset = new ImmutableAuditLogChangeset.Builder(auditLogChangeset).setAuthor(auditLogAuthor).build();
            return new AuditLogChangesetEntity(this.populateChangeset((AuditLogChangeset)changeset));
        }).collect(Collectors.toList());
    }

    @Override
    public BulkAuditMapper<TransactionGroup<InternalGroup, Serializable>> auditBulkRemoveGroups() {
        AuditLogAuthor auditLogAuthor = this.auditLogMetadataResolver.resolveAuthor();
        return transactionGroups -> transactionGroups.stream().map(TransactionGroup::getPrimaryObject).map(group -> {
            AuditLogChangeset auditLogChangeset = this.prepareAuditLogChangeset(AuditLogEventType.GROUP_CREATED, (InternalGroup)group, this.getDirectory((InternalGroup)group), this.auditLogGroupMapper.calculateDifference(null, (Group)group));
            ImmutableAuditLogChangeset changeset = new ImmutableAuditLogChangeset.Builder(auditLogChangeset).setAuthor(auditLogAuthor).build();
            return new AuditLogChangesetEntity(this.populateChangeset((AuditLogChangeset)changeset));
        }).collect(Collectors.toList());
    }

    private AuditLogChangeset prepareAuditLogChangeset(AuditLogEventType eventType, InternalGroup group, Directory directory, List<AuditLogEntry> diffEntries) {
        ImmutableAuditLogEntity directoryEntity = new ImmutableAuditLogEntity.Builder().setEntityId(directory.getId()).setEntityName(directory.getName()).setEntityType(AuditLogEntityType.DIRECTORY).build();
        ImmutableAuditLogEntity primaryGroupEntity = new ImmutableAuditLogEntity.Builder().setEntityName(group.getName()).setEntityId(group.getId()).setEntityType(AuditLogEntityType.GROUP).setPrimary().build();
        ImmutableAuditLogChangeset auditLogChangeset = new ImmutableAuditLogChangeset.Builder().addEntity(primaryGroupEntity).addEntity(directoryEntity).setEventType(eventType).addEntries(diffEntries).build();
        return auditLogChangeset;
    }

    private AuditLogChangeset populateChangeset(AuditLogChangeset auditLogChangeset) {
        return this.auditLogChangesetPopulator.populateCommonChangesetProperties(auditLogChangeset, false);
    }

    private Directory getDirectory(InternalGroup group) {
        Directory directory;
        try {
            directory = this.directoryDao.findById(group.getDirectoryId());
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException("Failed to get the directory for group " + String.valueOf(group), e);
        }
        return directory;
    }
}

