/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.audit.processor.impl;

import com.atlassian.crowd.audit.AuditLogAuthor;
import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.AuditLogEntityType;
import com.atlassian.crowd.audit.AuditLogEntry;
import com.atlassian.crowd.audit.AuditLogEventType;
import com.atlassian.crowd.audit.ImmutableAuditLogChangeset;
import com.atlassian.crowd.audit.ImmutableAuditLogEntity;
import com.atlassian.crowd.common.properties.StringSystemProperty;
import com.atlassian.crowd.dao.audit.AuditDao;
import com.atlassian.crowd.dao.audit.processor.UserAuditProcessor;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.audit.AuditLogChangesetPopulator;
import com.atlassian.crowd.manager.audit.AuditLogMetadataResolver;
import com.atlassian.crowd.manager.audit.mapper.AuditLogUserMapper;
import com.atlassian.crowd.model.audit.AuditLogChangesetEntity;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserAttribute;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.util.persistence.hibernate.batch.BulkAuditMapper;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.DiffResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserAuditProcessor
implements UserAuditProcessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserAuditProcessor.class);
    private final AuditDao auditDao;
    private final DirectoryDao directoryDao;
    private final AuditLogChangesetPopulator auditLogChangesetPopulator;
    private final AuditLogUserMapper auditLogUserMapper;
    private final AuditLogMetadataResolver auditLogMetadataResolver;
    private final Set<String> ignoredAttributes;

    public DefaultUserAuditProcessor(AuditDao auditDao, DirectoryDao directoryDao, AuditLogChangesetPopulator auditLogChangesetPopulator, AuditLogUserMapper auditLogUserMapper, AuditLogMetadataResolver auditLogMetadataResolver) {
        this(auditDao, directoryDao, auditLogChangesetPopulator, auditLogUserMapper, auditLogMetadataResolver, Stream.of(((String)new StringSystemProperty("crowd.auditlog.ignored_attributes", "lastActive,lastAuthenticated").getValue()).split(",")).collect(Collectors.toSet()));
    }

    DefaultUserAuditProcessor(AuditDao auditDao, DirectoryDao directoryDao, AuditLogChangesetPopulator auditLogChangesetPopulator, AuditLogUserMapper auditLogUserMapper, AuditLogMetadataResolver auditLogMetadataResolver, Set<String> ignoredAttributes) {
        this.auditDao = auditDao;
        this.directoryDao = directoryDao;
        this.auditLogChangesetPopulator = auditLogChangesetPopulator;
        this.auditLogUserMapper = auditLogUserMapper;
        this.auditLogMetadataResolver = auditLogMetadataResolver;
        this.ignoredAttributes = ignoredAttributes;
    }

    @Override
    public BulkAuditMapper<TransactionGroup<InternalUser, InternalUserAttribute>> auditBulkAddUsers() {
        AuditLogAuthor auditLogAuthor = this.auditLogMetadataResolver.resolveAuthor();
        return userTransactionGroups -> userTransactionGroups.stream().map(tg -> {
            InternalUser user = (InternalUser)tg.getPrimaryObject();
            Directory directory = this.getDirectory(user);
            List entries = this.auditLogUserMapper.calculateDifference(AuditLogEventType.USER_CREATED, null, (User)user);
            AuditLogChangeset auditLogChangeset = this.prepareUserAuditLogChangeset(AuditLogEventType.USER_CREATED, user, entries, directory);
            ImmutableAuditLogChangeset changesetWithAuthor = new ImmutableAuditLogChangeset.Builder(auditLogChangeset).setAuthor(auditLogAuthor).build();
            return new AuditLogChangesetEntity(this.populateChangeset((AuditLogChangeset)changesetWithAuthor));
        }).collect(Collectors.toList());
    }

    @Override
    public BulkAuditMapper<TransactionGroup<InternalUser, InternalUserAttribute>> auditBulkRemoveUsers() {
        AuditLogAuthor auditLogAuthor = this.auditLogMetadataResolver.resolveAuthor();
        return userTransactionGroups -> userTransactionGroups.stream().map(tg -> {
            InternalUser user = (InternalUser)tg.getPrimaryObject();
            Directory directory = this.getDirectory(user);
            List entries = this.auditLogUserMapper.calculateDifference(AuditLogEventType.USER_DELETED, (User)user, null);
            AuditLogChangeset auditLogChangeset = this.prepareUserAuditLogChangeset(AuditLogEventType.USER_DELETED, user, entries, directory);
            ImmutableAuditLogChangeset changesetWithAuthor = new ImmutableAuditLogChangeset.Builder(auditLogChangeset).setAuthor(auditLogAuthor).build();
            return new AuditLogChangesetEntity(this.populateChangeset((AuditLogChangeset)changesetWithAuthor));
        }).collect(Collectors.toList());
    }

    private Directory getDirectory(InternalUser user) {
        Directory directory;
        try {
            directory = this.directoryDao.findById(user.getDirectoryId());
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException("Failed to get the directory for user " + String.valueOf(user), e);
        }
        return directory;
    }

    private AuditLogChangeset prepareUserAuditLogChangeset(AuditLogEventType eventType, InternalUser user, List<AuditLogEntry> entries, Directory directory) {
        ImmutableAuditLogChangeset.Builder changesetBuilder = new ImmutableAuditLogChangeset.Builder().setEventType(eventType).addEntity(new ImmutableAuditLogEntity.Builder().setEntityId(user.getId()).setEntityName(user.getName()).setEntityType(AuditLogEntityType.USER).setPrimary().build());
        ImmutableAuditLogEntity directoryEntity = new ImmutableAuditLogEntity.Builder().setEntityId(directory.getId()).setEntityName(directory.getName()).setEntityType(AuditLogEntityType.DIRECTORY).build();
        if (eventType == AuditLogEventType.USER_CREATED && user.getCreatedDate() != null) {
            changesetBuilder.setTimestamp(user.getCreatedDate());
        }
        changesetBuilder.addEntity(directoryEntity);
        changesetBuilder.addEntries(entries);
        return changesetBuilder.build();
    }

    private AuditLogChangeset populateChangeset(AuditLogChangeset auditLogChangeset) {
        return this.auditLogChangesetPopulator.populateCommonChangesetProperties(auditLogChangeset, false);
    }

    private void auditUserEvent(AuditLogEventType eventType, InternalUser user, User oldUser, User newUser) {
        List entries = this.auditLogUserMapper.calculateDifference(eventType, oldUser, newUser);
        if (entries.isEmpty()) {
            log.debug("Omitting empty user changeset for event {} with user '{}'", (Object)eventType, (Object)user.getName());
            return;
        }
        AuditLogChangeset changeset = this.prepareUserAuditLogChangeset(eventType, user, entries, user.getDirectory());
        this.auditDao.add(new AuditLogChangesetEntity(this.populateChangeset(changeset)));
    }

    @Override
    public void auditUserAdded(InternalUser user) {
        this.auditUserEvent(AuditLogEventType.USER_CREATED, user, null, (User)user);
    }

    @Override
    public void auditUserRemoved(InternalUser user) {
        this.auditUserEvent(AuditLogEventType.USER_DELETED, user, (User)user, null);
    }

    @Override
    public void auditUserUpdated(User oldUser, InternalUser updatedUser) {
        this.auditUserEvent(AuditLogEventType.USER_UPDATED, updatedUser, oldUser, (User)updatedUser);
    }

    @Override
    public void auditCredentialUpdated(InternalUser userToUpdate) {
        Directory userDirectory = userToUpdate.getDirectory();
        ImmutableAuditLogEntity directoryEntity = new ImmutableAuditLogEntity.Builder().setEntityType(AuditLogEntityType.DIRECTORY).setEntityId(userDirectory.getId()).setEntityName(userDirectory.getName()).build();
        ImmutableAuditLogEntity primaryUserEntity = new ImmutableAuditLogEntity.Builder().setPrimary().setEntityName(userToUpdate.getName()).setEntityId(userToUpdate.getId()).setEntityType(AuditLogEntityType.USER).build();
        ImmutableAuditLogChangeset auditLogChangeset = new ImmutableAuditLogChangeset.Builder().setEventType(AuditLogEventType.PASSWORD_CHANGED).addEntity(primaryUserEntity).addEntity(directoryEntity).addEntry(this.auditLogUserMapper.calculatePasswordDiff()).build();
        AuditLogChangeset changeset = this.auditLogChangesetPopulator.populateCommonChangesetProperties((AuditLogChangeset)auditLogChangeset, false);
        this.auditDao.add(new AuditLogChangesetEntity(changeset));
    }

    @Override
    public void auditUserAttributesUpdated(InternalUser internalUser, DiffResult<?> changeSet) {
        List<AuditLogEntry> entries = this.auditLogUserMapper.mapDiffsToAuditLogEntries(AuditLogEventType.USER_UPDATED, internalUser.getName(), changeSet).stream().filter(entry -> !this.ignoredAttributes.contains(entry.getPropertyName())).collect(Collectors.toList());
        if (!entries.isEmpty()) {
            AuditLogChangeset changeset = this.prepareUserAuditLogChangeset(AuditLogEventType.USER_UPDATED, internalUser, entries, internalUser.getDirectory());
            this.auditDao.add(new AuditLogChangesetEntity(this.populateChangeset(changeset)));
        }
    }
}

