/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.audit.processor.impl;

import com.atlassian.crowd.dao.audit.processor.GroupAuditProcessor;
import com.atlassian.crowd.dao.audit.processor.impl.NoopAuditProcessor;
import com.atlassian.crowd.manager.audit.AuditLogEnabledChecker;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.util.persistence.hibernate.batch.BulkAuditMapper;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import java.io.Serializable;

public class DisablableGroupAuditProcessor
implements GroupAuditProcessor {
    private final NoopAuditProcessor noopAuditProcessor;
    private final GroupAuditProcessor groupAuditProcessor;
    private final AuditLogEnabledChecker auditLogEnabledChecker;

    public DisablableGroupAuditProcessor(NoopAuditProcessor noopAuditProcessor, GroupAuditProcessor groupAuditProcessor, AuditLogEnabledChecker auditLogEnabledChecker) {
        this.noopAuditProcessor = noopAuditProcessor;
        this.groupAuditProcessor = groupAuditProcessor;
        this.auditLogEnabledChecker = auditLogEnabledChecker;
    }

    @Override
    public void auditGroupAdded(InternalGroup group) {
        this.groupAuditProcessor().auditGroupAdded(group);
    }

    @Override
    public void auditGroupRemoved(InternalGroup group) {
        this.groupAuditProcessor().auditGroupRemoved(group);
    }

    @Override
    public void auditGroupUpdated(Group previous, InternalGroup updated) {
        this.groupAuditProcessor().auditGroupUpdated(previous, updated);
    }

    @Override
    public BulkAuditMapper<TransactionGroup<InternalGroup, Serializable>> auditBulkAddGroups() {
        return this.groupAuditProcessor().auditBulkAddGroups();
    }

    @Override
    public BulkAuditMapper<TransactionGroup<InternalGroup, Serializable>> auditBulkRemoveGroups() {
        return this.groupAuditProcessor().auditBulkRemoveGroups();
    }

    private GroupAuditProcessor groupAuditProcessor() {
        return this.auditLogEnabledChecker.shouldAuditEvent() ? this.groupAuditProcessor : this.noopAuditProcessor;
    }
}

