/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.audit.processor.impl;

import com.atlassian.crowd.dao.audit.processor.MembershipAuditProcessor;
import com.atlassian.crowd.dao.audit.processor.impl.NoopAuditProcessor;
import com.atlassian.crowd.manager.audit.AuditLogEnabledChecker;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.util.persistence.hibernate.batch.BulkAuditMapper;

public class DisablableMembershipAuditProcessor
implements MembershipAuditProcessor {
    private final NoopAuditProcessor noopAuditProcessor;
    private final MembershipAuditProcessor membershipAuditProcessor;
    private final AuditLogEnabledChecker auditLogEnabledChecker;

    public DisablableMembershipAuditProcessor(NoopAuditProcessor noopAuditProcessor, MembershipAuditProcessor membershipAuditProcessor, AuditLogEnabledChecker auditLogEnabledChecker) {
        this.noopAuditProcessor = noopAuditProcessor;
        this.membershipAuditProcessor = membershipAuditProcessor;
        this.auditLogEnabledChecker = auditLogEnabledChecker;
    }

    @Override
    public void auditMembershipAdded(InternalMembership membership) {
        this.membershipAuditProcessor().auditMembershipAdded(membership);
    }

    @Override
    public void auditMembershipRemoved(InternalMembership membership) {
        this.membershipAuditProcessor().auditMembershipRemoved(membership);
    }

    @Override
    public BulkAuditMapper<InternalMembership> auditBulkAddMemberships() {
        return this.membershipAuditProcessor().auditBulkAddMemberships();
    }

    @Override
    public BulkAuditMapper<InternalMembership> auditBulkRemoveMemberships() {
        return this.membershipAuditProcessor().auditBulkRemoveMemberships();
    }

    private MembershipAuditProcessor membershipAuditProcessor() {
        return this.auditLogEnabledChecker.shouldAuditEvent() ? this.membershipAuditProcessor : this.noopAuditProcessor;
    }
}

