/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.cluster;

import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.cluster.ClusterHeartbeatEntity;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

public class ClusterHeartbeatDAOHibernate
extends HibernateDao<ClusterHeartbeatEntity> {
    private static final Logger log = LoggerFactory.getLogger(ClusterHeartbeatDAOHibernate.class);

    @Override
    public Class<ClusterHeartbeatEntity> getPersistentClass() {
        return ClusterHeartbeatEntity.class;
    }

    public String writeNewHeartbeat(Supplier<String> nodeIdSupplier, String nodeName, long timestamp) throws OperationFailedException {
        for (int retry = 0; retry < 100; ++retry) {
            String nodeId = nodeIdSupplier.get();
            try {
                log.debug("Trying to write node heartbeat with node id: {}", (Object)nodeId);
                return (String)((Object)this.withStatelessSession(statelessSession -> statelessSession.insert((Object)new ClusterHeartbeatEntity(nodeId, nodeName, timestamp))));
            }
            catch (ConstraintViolationException e) {
                log.debug("Failed writing heartbeat with node id {}", (Object)nodeId);
                continue;
            }
        }
        throw new OperationFailedException("Unable to write unique node id");
    }

    public void writeHeartBeat(ClusterHeartbeatEntity heartbeatEntity) throws DataAccessException {
        log.debug("Trying to write node heartbeat: {}", (Object)heartbeatEntity);
        this.withStatelessSession(statelessSession -> {
            int updated = statelessSession.createQuery("update ClusterHeartbeatEntity hb set hb.nodeName = :nodeName, hb.timestamp = :timestamp where hb.nodeId = :nodeId").setParameter("nodeName", (Object)heartbeatEntity.getNodeName()).setParameter("timestamp", (Object)heartbeatEntity.getTimestamp()).setParameter("nodeId", (Object)heartbeatEntity.getNodeId()).executeUpdate();
            if (updated == 0) {
                statelessSession.insert((Object)heartbeatEntity);
            }
            return null;
        });
        log.debug("Finished writing node heartbeat: {}", (Object)heartbeatEntity);
    }

    @Nullable
    public ClusterHeartbeatEntity getHeartbeat(String nodeId) {
        return this.withStatelessSession(statelessSession -> (ClusterHeartbeatEntity)statelessSession.get(ClusterHeartbeatEntity.class, (Serializable)((Object)nodeId)));
    }

    public List<ClusterHeartbeatEntity> findHeartbeatsAfter(long timestamp) {
        return this.withStatelessSession(statelessSession -> statelessSession.getNamedQuery("findHeartbeatsAfter").setParameter("timestamp", (Object)timestamp).list());
    }

    public int removeHeartbeatsBefore(long timestamp) {
        return this.withStatelessSession(statelessSession -> statelessSession.createQuery("delete from ClusterHeartbeatEntity h where h.timestamp < :timestamp").setParameter("timestamp", (Object)timestamp).executeUpdate());
    }
}

