/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.cluster;

import com.atlassian.crowd.model.cluster.ClusterLockEntity;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.LogSuppressingUtil;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.List;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.GenericJDBCException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterLockDAOHibernate
extends HibernateDao<ClusterLockEntity> {
    private static final Logger log = LoggerFactory.getLogger(ClusterLockDAOHibernate.class);
    public static final String SUPPRESS_LOGGING_MDC_KEY = "suppress_hibernate_logging";

    @Override
    public Class<ClusterLockEntity> getPersistentClass() {
        return ClusterLockEntity.class;
    }

    public List<ClusterLockEntity> getAllHeldClusterLocks() {
        return this.withStatelessSession(statelessSession -> statelessSession.createQuery("from ClusterLockEntity where nodeId is not null", ClusterLockEntity.class).list());
    }

    public ClusterLockEntity getLockByName(String lockName) {
        return this.withStatelessSession(statelessSession -> (ClusterLockEntity)statelessSession.get(ClusterLockEntity.class, (Serializable)((Object)lockName)));
    }

    public boolean tryUpdateAcquireLock(@Nonnull String lockName, @Nonnull String nodeId, long currentTime, long lockExpiryTimeout) {
        return this.withStatelessSession(statelessSession -> {
            boolean acquired;
            int updateCount = statelessSession.createQuery("update ClusterLockEntity set nodeId=:nodeId, timestamp=:timestamp where lockName=:lockName and (nodeId IS NULL or nodeId IN (select h.nodeId from ClusterHeartbeatEntity h where h.timestamp < :nodeLivelinessThreshold) or nodeId = :nodeId)").setParameter("nodeId", (Object)nodeId).setParameter("timestamp", (Object)currentTime).setParameter("lockName", (Object)lockName).setParameter("nodeLivelinessThreshold", (Object)(currentTime - lockExpiryTimeout)).executeUpdate();
            Preconditions.checkState((updateCount <= 1 ? 1 : 0) != 0);
            boolean bl = acquired = updateCount == 1;
            if (acquired) {
                log.debug("Acquired lock {} for node {}", (Object)lockName, (Object)nodeId);
            } else {
                log.debug("Didn't acquire lock {} for node {}", (Object)lockName, (Object)nodeId);
            }
            return acquired;
        });
    }

    public void renewLease(@Nonnull String lockName, @Nonnull String nodeId, long currentTime) {
        this.withStatelessSession(statelessSession -> {
            int updateCount = statelessSession.createQuery("update ClusterLockEntity set timestamp=:timestamp where lockName=:lockName and nodeId=:nodeId").setParameter("nodeId", (Object)nodeId).setParameter("timestamp", (Object)currentTime).setParameter("lockName", (Object)lockName).executeUpdate();
            Preconditions.checkState((updateCount <= 1 ? 1 : 0) != 0);
            if (updateCount != 1) {
                throw new IllegalMonitorStateException(String.format("Failed to renew lease on lock %s for node %s - lock does not exist or is owned by another node", lockName, nodeId));
            }
            log.debug("Renewed lease on lock {} for node {}", (Object)lockName, (Object)nodeId);
            return null;
        });
    }

    public void insertEmptyClusterLock(@Nonnull String lockName, long currentTime) {
        try {
            LogSuppressingUtil.withSuppressedHibernateLogging(() -> this.withStatelessSession(statelessSession -> {
                statelessSession.insert((Object)new ClusterLockEntity(lockName, null, currentTime));
                log.debug("Inserted empty lock {}", (Object)lockName);
                return null;
            }));
        }
        catch (ConstraintViolationException e) {
            log.debug("Didn't insert empty lock {}, because lock already exists", (Object)lockName);
        }
        catch (GenericJDBCException e) {
            if (this.getLockByName(lockName) == null) {
                throw e;
            }
            log.debug("Didn't insert empty lock {}, because lock already exists", (Object)lockName, (Object)e);
        }
    }

    public void unlock(String lockName, String nodeId, long currentTime) {
        int updateCount = this.withStatelessSession(statelessSession -> statelessSession.createQuery("update ClusterLockEntity set nodeId = null, timestamp = :timeStamp where lockName = :lockName and nodeId = :nodeId").setParameter("lockName", (Object)lockName).setParameter("nodeId", (Object)nodeId).setParameter("timeStamp", (Object)currentTime).executeUpdate());
        Preconditions.checkState((updateCount <= 1 ? 1 : 0) != 0);
        if (updateCount != 1) {
            throw new IllegalMonitorStateException(String.format("Not releasing lock %s because it isn't held by node %s", lockName, nodeId));
        }
        log.debug("Released lock {} for node {}", (Object)lockName, (Object)nodeId);
    }

    public List<ClusterLockEntity> list() {
        return this.withStatelessSession(statelessSession -> statelessSession.createQuery("from ClusterLockEntity ").list());
    }

    public void deleteLocksHeldByNode(String nodeId) {
        this.withStatelessSession(statelessSession -> statelessSession.createQuery("delete ClusterLockEntity where nodeId=:nodeId").setParameter("nodeId", (Object)nodeId).executeUpdate());
    }
}

