/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.directory;

import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.directory.DirectorySynchronisationStatusImpl;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectorySynchronisationStatusDao;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.directory.DirectorySynchronisationStatus;
import com.atlassian.crowd.model.directory.SynchronisationStatusKeyParamsSerde;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.query.Query;

public class DirectorySynchronisationStatusDAOHibernate
extends HibernateDao<DirectorySynchronisationStatusImpl>
implements DirectorySynchronisationStatusDao {
    private DirectoryDAOHibernate directoryDao;

    public void setDirectoryDao(DirectoryDAOHibernate directoryDao) {
        this.directoryDao = directoryDao;
    }

    @Override
    public Class<DirectorySynchronisationStatusImpl> getPersistentClass() {
        return DirectorySynchronisationStatusImpl.class;
    }

    public Optional<DirectorySynchronisationStatus> findActiveForDirectory(long directoryId) {
        return this.firstResult("activeSynchronisationStatusForDirectory", directoryId);
    }

    public Optional<DirectorySynchronisationStatus> findLastForDirectory(long directoryId) {
        return this.firstResult("lastSynchronisationStatusForDirectory", directoryId);
    }

    private Optional<DirectorySynchronisationStatus> firstResult(String queryName, long directoryId) {
        return this.session().createNamedQuery(queryName, DirectorySynchronisationStatusImpl.class).setParameter("directoryId", (Object)directoryId).setMaxResults(1).uniqueResultOptional().map(Function.identity());
    }

    public DirectorySynchronisationStatus update(DirectorySynchronisationStatus status) throws ObjectNotFoundException {
        Preconditions.checkNotNull((Object)status.getId(), (Object)"Tried to update DirectorySynchronisationStatus without an id");
        DirectorySynchronisationStatusImpl activeSync = (DirectorySynchronisationStatusImpl)this.load(status.getId());
        activeSync.setStartTimestamp(status.getStartTimestamp());
        activeSync.setEndTimestamp(status.getEndTimestamp());
        activeSync.setStatus(status.getStatus());
        activeSync.setStatusParameters(status.getStatusParameters());
        activeSync.setNodeId(status.getNodeId());
        activeSync.setNodeName(status.getNodeName());
        activeSync.setIncrementalSyncError(status.getIncrementalSyncError());
        activeSync.setFullSyncError(status.getFullSyncError());
        super.update(activeSync);
        return activeSync;
    }

    public DirectorySynchronisationStatus add(DirectorySynchronisationStatus status) {
        Preconditions.checkArgument((status.getId() == null ? 1 : 0) != 0, (Object)"Tried to create DirectorySynchronisationStatus with id specified");
        DirectoryImpl directory = (DirectoryImpl)this.directoryDao.loadReference(status.getDirectory().getId());
        DirectorySynchronisationStatusImpl newStatus = DirectorySynchronisationStatusImpl.builder((DirectorySynchronisationStatus)status, SynchronisationStatusKeyParamsSerde::marshallParams).setDirectory((Directory)directory).build();
        super.save(newStatus);
        return newStatus;
    }

    public long removeStatusesForDirectory(Long directoryId) {
        Query query = this.session().getNamedQuery("clearStatusesForDirectory");
        query.setParameter("directoryId", (Object)directoryId);
        return query.executeUpdate();
    }

    public long removeAll() {
        Query query = this.session().getNamedQuery("clearAllStatutes");
        return query.executeUpdate();
    }

    public long removeAllExcept(long directoryId, int statusId) {
        Query query = this.session().getNamedQuery("clearStatusesExcept");
        query.setParameter("statusId", (Object)statusId);
        query.setParameter("directoryId", (Object)directoryId);
        return query.executeUpdate();
    }

    public Collection<DirectorySynchronisationStatus> findActiveSyncsWhereNodeIdNotIn(Set<String> nodesIds) {
        Preconditions.checkArgument((!nodesIds.isEmpty() ? 1 : 0) != 0, (Object)"nodesIds can't be an empty set");
        Query query = this.session().getNamedQuery("activeSynchronisationStatusesForNodesNotIn");
        query.setParameterList("nodes", nodesIds);
        return query.list();
    }
}

