/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.directory;

import com.atlassian.crowd.directory.DirectorySynchronisationToken;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.DirectorySynchronisationTokenDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import jakarta.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class DirectorySynchronisationTokenDaoHibernate
extends HibernateDao<DirectorySynchronisationToken>
implements DirectorySynchronisationTokenDao {
    private DirectoryDao directoryDao;

    @Nullable
    public String getLastSynchronisationTokenForDirectory(long directoryId) {
        return this.loadOptional(Long.valueOf(directoryId)).map(DirectorySynchronisationToken::getSynchronisationToken).orElse(null);
    }

    public void storeSynchronisationTokenForDirectory(long directoryId, String synchronisationToken) throws DirectoryNotFoundException {
        DirectorySynchronisationToken token = this.loadOptional(Long.valueOf(directoryId)).orElse(null);
        if (token == null) {
            Directory directory = this.directoryDao.findById(directoryId);
            token = new DirectorySynchronisationToken(directory, synchronisationToken);
        } else {
            token.setSynchronisationToken(synchronisationToken);
        }
        this.session().saveOrUpdate((Object)token);
    }

    public void clearSynchronisationTokenForDirectory(long directoryId) {
        this.removeByIdIfPresent(Long.valueOf(directoryId));
    }

    @Override
    public Class<DirectorySynchronisationToken> getPersistentClass() {
        return DirectorySynchronisationToken.class;
    }

    @Autowired
    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }
}

