/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.group;

import com.atlassian.crowd.dao.audit.processor.GroupAuditProcessor;
import com.atlassian.crowd.dao.group.InternalGroupDao;
import com.atlassian.crowd.dao.membership.InternalMembershipDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.model.InternalDirectoryEntity;
import com.atlassian.crowd.model.InternalEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.group.InternalGroupAttribute;
import com.atlassian.crowd.model.group.InternalGroupWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.HqlInClauseBatchHelper;
import com.atlassian.crowd.util.persistence.hibernate.InternalDirectoryEntityHibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5.operation.MergeOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5.operation.RemoveGroupOperation;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class GroupDAOHibernate
extends InternalDirectoryEntityHibernateDao<InternalGroup, InternalGroupAttribute>
implements InternalGroupDao,
GroupDao {
    public static final String EXTERNAL_ID = "externalId";
    public static final String DIRECTORY_ID = "directory.id";
    public static final String IS_LOCAL = "local";
    public static final String NAME = "name";
    private DirectoryDao directoryDao;
    private HQLQueryTranslater hqlQueryTranslater;
    private InternalMembershipDao membershipDao;
    private GroupAuditProcessor auditProcessor;

    public InternalGroup add(Group group) throws DirectoryNotFoundException, InvalidGroupException {
        return this.add(group, false);
    }

    public BatchResult<Group> addAll(Set<? extends Group> groups) throws DirectoryNotFoundException {
        HashSet<TransactionGroup> transactionGroups = new HashSet<TransactionGroup>();
        HashSet<Group> groupsFailedValidation = new HashSet<Group>();
        for (Group group : groups) {
            try {
                InternalGroup groupToAdd = new InternalGroup(group, this.getDirectory(group));
                this.updateTimestamps((InternalEntity)groupToAdd, true);
                TransactionGroup transactionWithInternalGroup = new TransactionGroup.Builder((Serializable)groupToAdd).build();
                transactionGroups.add(transactionWithInternalGroup);
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Could not add group <" + group.getName() + ">: " + e.getMessage());
                groupsFailedValidation.add(group);
            }
        }
        BatchResult transactionalBatchResult = this.batchProcessor.execute(new MergeOperation(), transactionGroups, this.auditProcessor.auditBulkRemoveGroups());
        return BatchResult.transform((BatchResult)transactionalBatchResult, TransactionGroup::getPrimaryObject);
    }

    public BatchResultWithIdReferences<Group> addAll(Collection<InternalGroupWithAttributes> groups) {
        HashSet<TransactionGroup> transactionGroups = new HashSet<TransactionGroup>();
        HashSet<InternalGroupWithAttributes> groupsFailedValidation = new HashSet<InternalGroupWithAttributes>();
        for (InternalGroupWithAttributes group : groups) {
            try {
                InternalGroup groupToAdd = group.getInternalGroup();
                HashSet<InternalGroupAttribute> attribs = new HashSet<InternalGroupAttribute>();
                for (String name : group.getKeys()) {
                    for (String val : group.getValues(name)) {
                        InternalGroupAttribute attrib = new InternalGroupAttribute(groupToAdd, name, val);
                        attribs.add(attrib);
                    }
                }
                TransactionGroup transactionWithInternalGroup = new TransactionGroup.Builder((Serializable)groupToAdd).withDependantObjects(attribs).build();
                transactionGroups.add(transactionWithInternalGroup);
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Could not add group <" + group.getName() + ">: " + e.getMessage());
                groupsFailedValidation.add(group);
            }
        }
        BatchResult transactionGroupBatchResult = this.batchProcessor.execute(new MergeOperation(), transactionGroups);
        BatchResultWithIdReferences groupBatchResultWithIdReferences = (BatchResultWithIdReferences)BatchResult.transform((BatchResult)transactionGroupBatchResult, TransactionGroup::getPrimaryObject, () -> new BatchResultWithIdReferences(groups.size()));
        groupBatchResultWithIdReferences.addFailures(groupsFailedValidation);
        for (TransactionGroup group : transactionGroups) {
            groupBatchResultWithIdReferences.addIdReference((InternalDirectoryEntity)group.getPrimaryObject());
        }
        return groupBatchResultWithIdReferences;
    }

    public InternalGroup addLocal(Group group) throws DirectoryNotFoundException, InvalidGroupException {
        return this.add(group, true);
    }

    @Override
    public InternalGroup findByName(long directoryId, String groupName) throws GroupNotFoundException {
        InternalGroup result = this.findByNameInternal(directoryId, groupName);
        if (result == null) {
            throw new GroupNotFoundException(groupName);
        }
        return result;
    }

    private InternalGroup findByNameInternal(long directoryId, String groupName) {
        return (InternalGroup)this.session().createCriteria(InternalGroup.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).add((Criterion)Restrictions.eq((String)"lowerName", (Object)IdentifierUtils.toLowerCase((String)groupName))).uniqueResult();
    }

    public InternalGroupWithAttributes findByNameWithAttributes(long directoryId, String groupName) throws GroupNotFoundException {
        return new InternalGroupWithAttributes(this.findByName(directoryId, groupName));
    }

    public Collection<InternalGroup> findByNames(long directoryID, Collection<String> groupnames) {
        return this.batchFinder.find(directoryID, groupnames, InternalGroup.class);
    }

    public Collection<InternalGroup> findByIds(Collection<Long> groupIds) {
        return HqlInClauseBatchHelper.ofNamedQuery(this.session(), "findGroupsByIds").query("groupIds", groupIds);
    }

    public Set<InternalGroupAttribute> findGroupAttributes(long groupId) {
        return Sets.newHashSet((Iterable)this.session().createCriteria(InternalGroupAttribute.class).add((Criterion)Restrictions.eq((String)"group.id", (Object)groupId)).list());
    }

    @Override
    public Class<InternalGroup> getPersistentClass() {
        return InternalGroup.class;
    }

    public void remove(Group group) throws GroupNotFoundException {
        InternalGroup groupToRemove = this.findByName(group.getDirectoryId(), group.getName());
        this.membershipDao.removeGroupMembers(group.getDirectoryId(), group.getName());
        this.membershipDao.removeGroupMemberships(group.getDirectoryId(), group.getName());
        this.session().getNamedQuery("removeAllInternalGroupAttributes").setEntity("group", (Object)groupToRemove).executeUpdate();
        super.remove(groupToRemove);
        this.auditProcessor.auditGroupRemoved(groupToRemove);
    }

    public void removeAll(long directoryId) {
        this.membershipDao.removeAllRelationships(directoryId);
        List ids = this.session().getNamedQuery("fetchIdsOfGroupGrantsToDelete").setLong("directoryId", directoryId).list();
        HqlInClauseBatchHelper.ofNamedQuery(this.session(), "removeGroupAdministrationGrantsById").executeUpdate("ids", ids);
        this.session().getNamedQuery("removeAllInternalGroupAttributesInDirectory").setLong("directoryId", directoryId).executeUpdate();
        this.session().getNamedQuery("removeAllGroupsInDirectory").setLong("directoryId", directoryId).executeUpdate();
    }

    public BatchResult<String> removeAllGroups(long directoryId, Set<String> groupNames) {
        Collection<InternalGroup> groups = this.findByNames(directoryId, groupNames);
        Set transactionGroups = groups.stream().map(group -> new TransactionGroup.Builder((Serializable)group).build()).collect(Collectors.toSet());
        BatchResult transactionGroupBatchResult = this.batchProcessor.execute(new RemoveGroupOperation(), transactionGroups, this.auditProcessor.auditBulkAddGroups());
        return BatchResult.transform((BatchResult)transactionGroupBatchResult, entity -> ((InternalGroup)entity.getPrimaryObject()).getName());
    }

    public Set<String> getAllExternalIds(long directoryId) throws DirectoryNotFoundException {
        this.getDirectory(directoryId);
        return ImmutableSet.copyOf((Collection)this.session().createCriteria(InternalGroup.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).add(Restrictions.isNotNull((String)EXTERNAL_ID)).add((Criterion)Restrictions.eq((String)IS_LOCAL, (Object)false)).setProjection((Projection)Projections.property((String)EXTERNAL_ID)).list());
    }

    public Set<String> getLocalGroupNames(long directoryId) throws DirectoryNotFoundException {
        this.getDirectory(directoryId);
        return ImmutableSet.copyOf((Collection)this.session().createCriteria(InternalGroup.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).add((Criterion)Restrictions.eq((String)IS_LOCAL, (Object)true)).setProjection((Projection)Projections.property((String)NAME)).list());
    }

    public long getGroupCount(long directoryId) throws DirectoryNotFoundException {
        this.getDirectory(directoryId);
        return ((Number)this.session().createCriteria(InternalGroup.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).setProjection(Projections.rowCount()).uniqueResult()).longValue();
    }

    public long getExternalGroupCount(long directoryId) throws DirectoryNotFoundException {
        this.getDirectory(directoryId);
        return ((Number)this.session().createCriteria(InternalGroup.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).add((Criterion)Restrictions.eq((String)IS_LOCAL, (Object)false)).setProjection(Projections.rowCount()).uniqueResult()).longValue();
    }

    public void removeAttribute(Group group, String attributeName) throws GroupNotFoundException {
        InternalGroup internalGroup = this.findByName(group.getDirectoryId(), group.getName());
        this.updateTimestamps((InternalEntity)internalGroup, false);
        this.removeAttribute(internalGroup, attributeName);
    }

    public InternalGroup rename(Group group, String newName) throws GroupNotFoundException, InvalidGroupException {
        InternalGroup groupToRename = this.findByName(group.getDirectoryId(), group.getName());
        String oldName = groupToRename.getName();
        InternalGroup existingGroup = this.findByNameInternal(group.getDirectoryId(), newName);
        if (existingGroup != null) {
            throw new InvalidGroupException(group, "Cannot rename group as group with new name already exists: " + group.getName());
        }
        groupToRename.renameTo(newName);
        this.updateTimestamps((InternalEntity)groupToRename, false);
        super.update(groupToRename);
        this.membershipDao.renameGroupRelationships(groupToRename.getDirectoryId(), oldName, groupToRename.getName());
        return groupToRename;
    }

    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        Validate.isTrue((query.getEntityDescriptor().getEntityType() == Entity.GROUP ? 1 : 0) != 0, (String)"GroupDAO can only evaluate EntityQueries for Entity.GROUP", (Object[])new Object[0]);
        return this.executeBatchedQueriesIfNecessary(query, this.hqlQueryTranslater.asHQL(directoryId, query));
    }

    public Map<String, String> findByExternalIds(long directoryId, Set<String> externalIds) {
        List results = HqlInClauseBatchHelper.ofNamedQuery(this.session(), "findGroupNamesByExternalIds").withQueryConsumer(query -> query.setParameter("directoryId", (Object)directoryId)).query("externalIds", externalIds);
        return results.stream().collect(Collectors.toMap(tuple -> (String)tuple[0], tuple -> (String)tuple[1]));
    }

    public Map<String, String> findExternalIdsByNames(long directoryId, Set<String> groupNames) {
        List results = HqlInClauseBatchHelper.ofNamedQuery(this.session(), "findGroupExternalIdsByNames").withQueryConsumer(query -> query.setParameter("directoryId", (Object)directoryId)).query("groupNames", groupNames);
        return results.stream().collect(Collectors.toMap(tuple -> (String)tuple[0], tuple -> (String)tuple[1]));
    }

    public void storeAttributes(Group group, Map<String, Set<String>> attributes) throws GroupNotFoundException {
        InternalGroup internalGroup = this.findByName(group.getDirectoryId(), group.getName());
        this.updateTimestamps((InternalEntity)internalGroup, false);
        this.storeAttributes(internalGroup, attributes);
    }

    public InternalGroup update(Group group) throws GroupNotFoundException {
        InternalGroup groupToUpdate = this.findByName(group.getDirectoryId(), group.getName());
        if (groupToUpdate.getType() != group.getType()) {
            throw new UnsupportedOperationException("Cannot modify the GroupType for an Internal group");
        }
        InternalGroup groupBeforeUpdate = new InternalGroup((Group)groupToUpdate, groupToUpdate.getDirectory());
        groupBeforeUpdate.setLocal(groupToUpdate.isLocal());
        groupToUpdate.updateDetailsFrom(group);
        this.updateTimestamps((InternalEntity)groupToUpdate, false);
        super.update(groupToUpdate);
        this.auditProcessor.auditGroupUpdated((Group)groupBeforeUpdate, groupToUpdate);
        return groupToUpdate;
    }

    private InternalGroup add(Group group, boolean local) throws DirectoryNotFoundException, InvalidGroupException {
        InternalGroup existingGroup = this.findByNameInternal(group.getDirectoryId(), group.getName());
        if (existingGroup != null) {
            throw new InvalidGroupException(group, "Cannot add group as group with new name already exists: " + group.getName());
        }
        InternalGroup groupToAdd = new InternalGroup(group, this.getDirectory(group));
        groupToAdd.setLocal(local);
        this.updateTimestamps((InternalEntity)groupToAdd, true);
        super.save(groupToAdd);
        this.auditProcessor.auditGroupAdded(groupToAdd);
        return groupToAdd;
    }

    @Override
    public void addAttribute(InternalGroup group, String attributeName, String attributeValue) {
        InternalGroupAttribute attribute = new InternalGroupAttribute(group, attributeName, attributeValue);
        this.session().save((Object)attribute);
        group.getAttributes().add(attribute);
    }

    private Directory getDirectory(Group group) throws DirectoryNotFoundException {
        Validate.notNull((Object)group.getDirectoryId(), (String)"Cannot add a group with null directoryId", (Object[])new Object[0]);
        return this.getDirectory(group.getDirectoryId());
    }

    private Directory getDirectory(long directoryId) throws DirectoryNotFoundException {
        return this.directoryDao.findById(directoryId);
    }

    @Autowired
    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    @Autowired
    public void setMembershipDao(InternalMembershipDao membershipDao) {
        this.membershipDao = membershipDao;
    }

    @Autowired
    public void setAuditProcessor(@Qualifier(value="groupAuditProcessor") GroupAuditProcessor auditProcessor) {
        this.auditProcessor = auditProcessor;
    }
}

