/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.permission;

import com.atlassian.crowd.dao.permission.GroupAdministrationGrantGroupDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.permission.GroupAdministrationGrantToGroup;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.HqlInClauseBatchHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.query.Query;

public class GroupAdministrationGrantGroupDaoHibernate
extends HibernateDao<GroupAdministrationGrantToGroup>
implements GroupAdministrationGrantGroupDao {
    public GroupAdministrationGrantToGroup add(GroupAdministrationGrantToGroup grant) {
        super.save(grant);
        return grant;
    }

    public List<GroupAdministrationGrantToGroup> findGrantsToGroup(InternalGroup targetGroup) {
        return this.findByProperty("targetGroup", targetGroup).list();
    }

    public List<GroupAdministrationGrantToGroup> findGrantsOfGroups(Collection<InternalGroup> groups) {
        if (groups.isEmpty()) {
            return Collections.emptyList();
        }
        return HqlInClauseBatchHelper.ofHqlQuery(this.session(), "from GroupAdministrationGrantToGroup g where g.group in :groups").query("groups", groups);
    }

    public List<GroupAdministrationGrantToGroup> findGrantsToGroupFromDirectory(InternalGroup group, Directory directory) {
        return this.findByProperties((Map<String, Object>)ImmutableMap.of((Object)"targetGroup", (Object)group, (Object)"group.directory", (Object)directory)).list();
    }

    public List<GroupAdministrationGrantToGroup> findAll() {
        return this.session().createQuery("from GroupAdministrationGrantToGroup", GroupAdministrationGrantToGroup.class).list();
    }

    public void remove(InternalGroup adminGroup, InternalGroup targetGroup) {
        Query query = this.session().createQuery("delete from GroupAdministrationGrantToGroup g where g.group.id =:ownerGroupId and g.targetGroup.id =:targetGroupId").setParameter("ownerGroupId", (Object)adminGroup.getId()).setParameter("targetGroupId", (Object)targetGroup.getId());
        query.executeUpdate();
    }

    @Override
    public Class<GroupAdministrationGrantToGroup> getPersistentClass() {
        return GroupAdministrationGrantToGroup.class;
    }
}

