/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.permission;

import com.atlassian.crowd.dao.permission.InternalUserPermissionDAO;
import com.atlassian.crowd.manager.permission.PermittedGroup;
import com.atlassian.crowd.manager.permission.PermittedGroupImpl;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.permission.InternalGrantedPermission;
import com.atlassian.crowd.model.permission.UserPermission;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.transform.BasicTransformerAdapter;
import org.hibernate.transform.ResultTransformer;

public class UserPermissionDAOHibernate
extends HibernateDao<InternalGrantedPermission>
implements InternalUserPermissionDAO {
    @Override
    public Class<InternalGrantedPermission> getPersistentClass() {
        return InternalGrantedPermission.class;
    }

    public void grant(InternalGrantedPermission permission) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)permission.getGroupName()));
        Preconditions.checkNotNull((Object)permission.getPermission());
        permission.setCreatedDate(new Date());
        this.saveOrUpdate(permission);
    }

    public Collection<PermittedGroup> getGrantedPermissions(UserPermission permission) {
        return this.session().createCriteria(InternalGrantedPermission.class).add((Criterion)Restrictions.eq((String)"permission", (Object)permission)).list();
    }

    public Collection<PermittedGroup> getGrantedPermissions(UserPermission permission, Application application) {
        return this.session().createQuery("from InternalGrantedPermission grant where grant.permission = :permission and directoryMapping.application.id = :application").setParameter("permission", (Object)permission).setParameter("application", (Object)application.getId()).list();
    }

    public List<PermittedGroup> findHighestPermissionPerGroupByPrefix(String prefix, int start, int limit) {
        Preconditions.checkNotNull((Object)prefix);
        Criteria criteria = this.buildCriteria(start, limit);
        if (!prefix.isEmpty()) {
            criteria.add(Restrictions.ilike((String)"groupName", (String)prefix, (MatchMode)MatchMode.START));
        }
        return criteria.list();
    }

    public List<PermittedGroup> findHighestPermissionPerGroup(int start, int limit) {
        return this.buildCriteria(start, limit).list();
    }

    private Criteria buildCriteria(int start, int limit) {
        Criteria criteria = this.session().createCriteria(InternalGrantedPermission.class).setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)"directoryMapping")).add((Projection)Projections.groupProperty((String)"groupName")).add((Projection)Projections.max((String)"permission"))).setFirstResult(start).addOrder(Order.asc((String)"groupName").ignoreCase()).setResultTransformer((ResultTransformer)new BasicTransformerAdapter(){

            public PermittedGroup transformTuple(Object[] tuple, String[] aliases) {
                DirectoryMapping directoryMapping = (DirectoryMapping)tuple[0];
                return new PermittedGroupImpl((UserPermission)tuple[2], directoryMapping.getDirectory().getId(), directoryMapping.getDirectory().getName(), (String)tuple[1]);
            }
        });
        if (limit > 0) {
            criteria.setMaxResults(limit);
        }
        return criteria;
    }

    public List<InternalGrantedPermission> findAllPermissionsForGroup(String groupName, long directoryId) {
        Criteria criteria = this.session().createCriteria(InternalGrantedPermission.class).createAlias("directoryMapping", "dm").addOrder(Order.asc((String)"groupName").ignoreCase()).add((Criterion)Restrictions.eq((String)"groupName", (Object)groupName)).add((Criterion)Restrictions.eq((String)"dm.directory.id", (Object)directoryId));
        return criteria.list();
    }

    public List<InternalGrantedPermission> findAllInternalGrantedPermissions() {
        return this.session().createCriteria(InternalGrantedPermission.class).list();
    }

    public boolean revoke(InternalGrantedPermission permission) {
        return this.createRevokeQuery(permission).executeUpdate() > 0;
    }

    public int revokeAll(DirectoryMapping directoryMapping) {
        return this.session().createQuery("delete InternalGrantedPermission perm where perm.directoryMapping = :directoryMapping").setParameter("directoryMapping", (Object)directoryMapping).executeUpdate();
    }

    @SuppressFBWarnings(value={"SQL_INJECTION"}, justification="Concatenating hardcoded strings only")
    private Query createRevokeQuery(InternalGrantedPermission grantedPermission) {
        Preconditions.checkArgument((grantedPermission.getGroupName() != null ? 1 : 0) != 0, (Object)"Group name to revoke must not be empty");
        return this.session().createQuery("delete " + InternalGrantedPermission.class.getSimpleName() + " perm where perm.permission = :permission and perm.directoryMapping = :directoryMapping and perm.groupName = :groupName").setParameter("permission", (Object)grantedPermission.getPermission()).setParameter("directoryMapping", (Object)grantedPermission.getDirectoryMapping()).setParameter("groupName", (Object)grantedPermission.getGroupName());
    }

    public boolean exists(InternalGrantedPermission grantedPermission) {
        Criteria criteria = this.createHasPermissionEntryCriteria(grantedPermission);
        return (Long)criteria.uniqueResult() > 0L;
    }

    private Criteria createHasPermissionEntryCriteria(InternalGrantedPermission grantedPermission) {
        return this.session().createCriteria(InternalGrantedPermission.class).add((Criterion)Restrictions.eq((String)"permission", (Object)grantedPermission.getPermission())).add((Criterion)Restrictions.eq((String)"directoryMapping", (Object)grantedPermission.getDirectoryMapping())).add((Criterion)Restrictions.eq((String)"groupName", (Object)grantedPermission.getGroupName())).setProjection((Projection)Projections.count((String)"id"));
    }
}

