/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.property;

import com.atlassian.crowd.dao.property.InternalPropertyDAO;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.model.property.PropertyId;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.io.Serializable;
import java.util.List;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.LockOptions;
import org.hibernate.NonUniqueObjectException;

public class PropertyDAOHibernate
extends HibernateDao<Property>
implements InternalPropertyDAO {
    public Property add(Property property) {
        super.save(property);
        return property;
    }

    public Property find(String key, String name) throws ObjectNotFoundException {
        return (Property)this.load((Serializable)new PropertyId(key, name));
    }

    public List<Property> findAll(String key) {
        return this.findByProperty("propertyId.key", key).list();
    }

    public List<Property> findAll() {
        return this.findAllInternal();
    }

    @Override
    public Class<Property> getPersistentClass() {
        return Property.class;
    }

    public void remove(String key, String name) {
        this.removeByIdIfPresent((Serializable)new PropertyId(key, name));
    }

    public Property update(Property property) {
        this.session().merge((Object)property);
        return property;
    }

    public void reassociate(Property property) {
        try {
            this.session().buildLockRequest(LockOptions.NONE).lock((Object)property);
        }
        catch (NonUniqueObjectException e) {
            this.session().evict(this.access().getReference((Serializable)new PropertyId(property.getKey(), property.getName())));
            this.session().buildLockRequest(LockOptions.NONE).lock((Object)property);
        }
    }

    private IdentifierLoadAccess<Property> access() {
        return this.session().byId(Property.class);
    }
}

