/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.sso;

import com.atlassian.crowd.dao.sso.SAMLTrustDAO;
import com.atlassian.crowd.embedded.api.DataReEncryptor;
import com.atlassian.crowd.model.sso.SAMLTrustEntityDaoSecretsWrapper;
import com.atlassian.crowd.model.sso.idp.SAMLTrustEntity;
import com.atlassian.crowd.secret.SecretServiceInternal;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLTrustDAOHibernate
extends HibernateDao<SAMLTrustEntity>
implements SAMLTrustDAO,
DataReEncryptor {
    private static final Logger log = LoggerFactory.getLogger(SAMLTrustDAOHibernate.class);
    private SAMLTrustEntityDaoSecretsWrapper secretsWrapper;

    public SAMLTrustDAOHibernate(SecretServiceInternal secretService) {
        this.secretsWrapper = new SAMLTrustEntityDaoSecretsWrapper(secretService);
    }

    public SAMLTrustEntity addSamlTrustEntity(SAMLTrustEntity samlTrustEntity) {
        if (this.secretsWrapper.isEnabled()) {
            return this.secretsWrapper.saveSecurely(samlTrustEntity, this::save);
        }
        log.warn("Secrets are not enabled, saving SAML trust entity without encryption");
        this.save(samlTrustEntity);
        return samlTrustEntity;
    }

    public Optional<SAMLTrustEntity> findSamlTrustEntityById(long trustEntityId) {
        if (this.secretsWrapper.isEnabled()) {
            return this.secretsWrapper.findById(trustEntityId, x$0 -> this.loadOptional((Serializable)x$0));
        }
        log.warn("Secrets are not enabled, loading SAML trust entity (id: {}) without decryption", (Object)trustEntityId);
        return this.loadOptional(Long.valueOf(trustEntityId));
    }

    public List<SAMLTrustEntity> findAll() {
        if (this.secretsWrapper.isEnabled()) {
            return this.secretsWrapper.findAll(this::findAllDirectly);
        }
        log.warn("Secrets are not enabled, loading all SAML trust entities without decryption");
        return this.findAllDirectly();
    }

    @Override
    public Class<SAMLTrustEntity> getPersistentClass() {
        return SAMLTrustEntity.class;
    }

    public void reEncrypt() {
        if (this.secretsWrapper.isEnabled()) {
            log.info("Re-encryption of SAML trust entities");
            this.secretsWrapper.reEncrypt(this::findAll, entity -> this.session().merge(entity));
        } else {
            log.warn("Secrets are not enabled, skipping re-encryption of SAML trust entities");
        }
    }

    public List<SAMLTrustEntity> findAllDirectly() {
        return this.session().createQuery("from SAMLTrustEntity").list();
    }
}

