/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.token;

import com.atlassian.crowd.dao.token.ExpirableUserTokenDao;
import com.atlassian.crowd.exception.ObjectAlreadyExistsException;
import com.atlassian.crowd.model.token.ExpirableUserToken;
import com.atlassian.crowd.model.token.ExpirableUserTokenType;
import com.atlassian.crowd.model.token.InternalExpirableUserToken;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.HibernateException;

public class ExpirableUserTokenDaoHibernate
extends HibernateDao<InternalExpirableUserToken>
implements ExpirableUserTokenDao {
    public ExpirableUserToken add(ExpirableUserToken token) throws ObjectAlreadyExistsException {
        try {
            this.session().save((Object)token);
            return token;
        }
        catch (HibernateException e) {
            throw new ObjectAlreadyExistsException(token.getToken(), (Throwable)e);
        }
    }

    public Optional<ExpirableUserToken> findByToken(String token) {
        return this.findByPropertyOptional("token", token).map(Function.identity());
    }

    public boolean removeByToken(String token) {
        int numDeleted = this.session().getNamedQuery("removeExpirableUserToken").setString("token", token).executeUpdate();
        return numDeleted > 0;
    }

    public boolean removeExpiredTokens(Date cutoffDate) {
        int numDeleted = this.session().getNamedQuery("removeExpiredUserTokens").setLong("date", cutoffDate.getTime()).executeUpdate();
        return numDeleted > 0;
    }

    public boolean removeByDirectoryAndUsername(long directoryId, String username, ExpirableUserTokenType expirableUserTokenType) {
        int numDeleted = this.session().getNamedQuery("removeExpirableUserTokensByUsernameAndDirectory").setString("username", username).setLong("directoryId", directoryId).setParameter("type", (Object)expirableUserTokenType).executeUpdate();
        return numDeleted > 0;
    }

    public Set<ExpirableUserToken> findAllTokens(long directoryId, String username, ExpirableUserTokenType expirableUserTokenType) {
        return this.findByProperties((Map<String, Object>)ImmutableMap.of((Object)"username", (Object)username, (Object)"directoryId", (Object)directoryId, (Object)"type", (Object)expirableUserTokenType)).getResultStream().collect(Collectors.toSet());
    }

    @Override
    public Class<InternalExpirableUserToken> getPersistentClass() {
        return InternalExpirableUserToken.class;
    }
}

