/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

public class BooleanTypeDescriptor
extends AbstractTypeDescriptor<Boolean> {
    public static final BooleanTypeDescriptor INSTANCE = new BooleanTypeDescriptor();
    private final String stringValueFalse;
    private final String stringValueTrue = String.valueOf(true);

    public BooleanTypeDescriptor() {
        super(Boolean.class);
        this.stringValueFalse = String.valueOf(false);
    }

    public Boolean fromString(String string) {
        return Boolean.valueOf(string);
    }

    public String toString(Boolean value) {
        return value == null ? null : value.toString();
    }

    public <X> X unwrap(Boolean value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)(value != false ? this.stringValueTrue : this.stringValueFalse);
        }
        throw this.unknownUnwrap(type);
    }

    public <X> Boolean wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return this.stringValueTrue.equals(value) ? Boolean.TRUE : Boolean.FALSE;
        }
        throw this.unknownWrap(value.getClass());
    }
}

