/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.config.db.HibernateConfig;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.crowd.util.persistence.hibernate.event.EmbeddedDatabaseInitEvent;
import com.atlassian.hibernate.extras.event.IdTransferringMergeEventListener;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.springframework.context.ApplicationEvent;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.orm.hibernate5.LocalSessionFactoryBuilder;

public class ConfigurableLocalSessionFactoryBean
extends LocalSessionFactoryBean {
    private static final UseDerivedDuplicationStrategy USE_DERIVED = new UseDerivedDuplicationStrategy();
    private HibernateConfig hibernateConfig;
    private StandardServiceInitiator<ConnectionProvider> connectionProviderInitiator;

    public ConfigurableLocalSessionFactoryBean(StandardServiceInitiator<ConnectionProvider> connectionProviderInitiator) {
        Preconditions.checkNotNull(connectionProviderInitiator, (Object)"Connection Provider Initiator cannot be null");
        this.connectionProviderInitiator = connectionProviderInitiator;
    }

    public void setHibernateConfig(HibernateConfig hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    public void afterPropertiesSet() throws IOException {
        if (this.hibernateConfig != null) {
            this.getHibernateProperties().putAll((Map<?, ?>)this.hibernateConfig.getHibernateProperties());
            if (this.hibernateConfig.isHSQL()) {
                BootstrapUtils.getBootstrapContext().publishEvent((ApplicationEvent)new EmbeddedDatabaseInitEvent((Object)this));
            }
        }
        super.afterPropertiesSet();
    }

    protected SessionFactory buildSessionFactory(LocalSessionFactoryBuilder sfb) {
        StandardServiceRegistryBuilder serviceRegistryBuilder = sfb.getStandardServiceRegistryBuilder();
        serviceRegistryBuilder.addInitiator(this.connectionProviderInitiator);
        SessionFactory sessionFactory = super.buildSessionFactory(sfb);
        this.registerEventListeners((SessionFactoryImplementor)sessionFactory);
        return sessionFactory;
    }

    private void registerEventListeners(SessionFactoryImplementor sessionFactory) {
        EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)sessionFactory.getServiceRegistry().getService(EventListenerRegistry.class);
        EventListenerGroup mergeListeners = eventListenerRegistry.getEventListenerGroup(EventType.MERGE);
        mergeListeners.addDuplicationStrategy((DuplicationStrategy)USE_DERIVED);
        mergeListeners.appendListener((Object)new IdTransferringMergeEventListener());
    }

    private static class UseDerivedDuplicationStrategy
    implements DuplicationStrategy {
        private UseDerivedDuplicationStrategy() {
        }

        public boolean areMatch(Object added, Object existing) {
            Class<?> existingClass = existing.getClass();
            Class<?> addedClass = added.getClass();
            return !addedClass.equals(existingClass) && existingClass.isInstance(added);
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.REPLACE_ORIGINAL;
        }
    }
}

