/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.secrets.api.SecretStore;
import com.atlassian.secrets.api.SecretStoreProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdHibernateConfig
extends HibernateConfig {
    private static final Logger log = LoggerFactory.getLogger(CrowdHibernateConfig.class);
    private static final Set<String> ENCRYPTABLE_PROPERTIES = ImmutableSet.of((Object)"hibernate.connection.password");
    private static final String AES_CIPHER = "com.atlassian.secrets.store.algorithm.AesOnlyAlgorithmSecretStore";
    private static final Set<String> ALLOWED_CIPHERS = ImmutableSet.of((Object)"com.atlassian.secrets.store.algorithm.AesOnlyAlgorithmSecretStore");
    private SecretStoreProvider cipherProvider;

    public Properties getHibernateProperties() {
        return this.decrypt(super.getHibernateProperties());
    }

    private Properties decrypt(Properties plainProperties) {
        return this.getCipherClassName().map(this::instantiateCipher).map(cipher -> this.decryptWithCipher(plainProperties, (SecretStore)cipher)).orElse(plainProperties);
    }

    private Optional<String> getCipherClassName() {
        ApplicationConfiguration crowdConfig = this.getApplicationConfig();
        return Optional.ofNullable(crowdConfig.getProperty((Object)"jdbc.password.decrypter.classname")).map(String::valueOf).map(cipher -> {
            boolean isLegacyClassUsed = cipher.equals("com.atlassian.db.config.password.ciphers.algorithm.AesOnlyAlgorithmCipher");
            if (isLegacyClassUsed) {
                log.info("Legacy AES cipher class detected. Updating to new class '{}'", (Object)AES_CIPHER);
                crowdConfig.setProperty((Object)"jdbc.password.decrypter.classname", (Object)AES_CIPHER);
                return AES_CIPHER;
            }
            return cipher;
        });
    }

    private Properties decryptWithCipher(Properties plainProperties, SecretStore cipher) {
        log.debug("Decrypting properties with cipher '{}'", (Object)cipher.getClass().getName());
        plainProperties.replaceAll((BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> this.decryptEntry(k, v, cipher)));
        return plainProperties;
    }

    private Object decryptEntry(Object key, Object value, SecretStore cipher) {
        return ENCRYPTABLE_PROPERTIES.contains(key) ? cipher.get(value.toString()) : value;
    }

    private SecretStore instantiateCipher(String cipherClassName) {
        Preconditions.checkState((boolean)ALLOWED_CIPHERS.contains(cipherClassName), (String)"Cipher '%s' is not allowed for database password encryption as it's not an instance of %s", (Object)cipherClassName, ALLOWED_CIPHERS);
        log.info("Password cipher property detected. Instantiating cipher for classname: '{}'", (Object)cipherClassName);
        return (SecretStore)this.cipherProvider.getInstance(cipherClassName).orElseThrow(() -> new IllegalStateException(String.format("Cipher '%s' not found", cipherClassName)));
    }

    public void setCipherProvider(SecretStoreProvider cipherProvider) {
        this.cipherProvider = cipherProvider;
    }

    public boolean isHSQL() {
        return super.isHSQL() || CrowdHibernateConfig.isCrowdHsql18Dialect((String)this.getApplicationConfig().getProperty((Object)"hibernate.dialect"));
    }

    public static boolean isCrowdHsql18Dialect(String dialect) {
        return null != dialect && dialect.matches(".*?CrowdHsql18.*?Dialect$");
    }
}

