/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.crowd.util.persistence.hibernate.batch.BatchConfigParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class HqlInClauseBatchHelper {
    private final Session session;
    private final Query query;
    private static int batchSize = new BatchConfigParser().getCrowdQueryBatchSize();
    private final Consumer<Query> queryConsumer;

    private HqlInClauseBatchHelper(HqlInClauseBatchHelperBuilder builder) {
        this.session = builder.session;
        this.query = builder.query;
        this.queryConsumer = builder.queryConsumer;
    }

    public static HqlInClauseBatchHelperBuilder ofNamedQuery(Session session, String queryName) {
        Objects.requireNonNull(queryName, "Query name must not be null");
        return new HqlInClauseBatchHelperBuilder(session, null, queryName);
    }

    public static HqlInClauseBatchHelperBuilder ofHqlQuery(Session session, String query) {
        Objects.requireNonNull(query, "Query must not be null");
        return new HqlInClauseBatchHelperBuilder(session, query, null);
    }

    public static <T> Iterable<List<T>> splitIntoBatches(Iterable<T> inClauseObjects) {
        return inClauseObjects == null ? Collections.emptyList() : Iterables.partition(inClauseObjects, (int)batchSize);
    }

    public static <T> List<List<T>> splitIntoBatchesList(Iterable<T> inClauseObjects) {
        return inClauseObjects == null ? Collections.emptyList() : Lists.partition((List)Lists.newArrayList(inClauseObjects), (int)batchSize);
    }

    @VisibleForTesting
    public static void setBatchSize(int newBatchSize) {
        batchSize = newBatchSize;
    }

    @VisibleForTesting
    public static int getBatchSize() {
        return batchSize;
    }

    public <T> void executeUpdate(String inClauseParameterName, Iterable<T> inClauseObjects) {
        Objects.requireNonNull(inClauseParameterName, "In clause parameter name must not be null");
        for (List<T> batch : HqlInClauseBatchHelper.splitIntoBatches(inClauseObjects)) {
            if (this.queryConsumer != null) {
                this.queryConsumer.accept(this.query);
            }
            this.query.setParameterList(inClauseParameterName, batch).executeUpdate();
            this.session.flush();
            this.session.clear();
        }
    }

    public <T> List<T> query(String inClauseParameterName, Iterable<?> inClauseObjects) {
        Objects.requireNonNull(inClauseParameterName, "In clause parameter name must not be null");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List<?> batch : HqlInClauseBatchHelper.splitIntoBatches(inClauseObjects)) {
            if (this.queryConsumer != null) {
                this.queryConsumer.accept(this.query);
            }
            List results = this.query.setParameterList(inClauseParameterName, batch).list();
            builder.addAll((Iterable)results);
        }
        return builder.build();
    }

    public static class HqlInClauseBatchHelperBuilder {
        private Session session;
        private Query query;
        private Consumer<Query> queryConsumer;

        private HqlInClauseBatchHelperBuilder(Session session, String query, String queryName) {
            this.session = Objects.requireNonNull(session, "Session object must not be null");
            this.query = !Strings.isNullOrEmpty((String)query) ? session.createQuery(query) : session.getNamedQuery(queryName);
        }

        public HqlInClauseBatchHelperBuilder withQueryConsumer(Consumer<Query> queryConsumer) {
            this.queryConsumer = queryConsumer;
            return this;
        }

        public <T> void executeUpdate(String parameterName, Iterable<T> inClauseObjects) {
            new HqlInClauseBatchHelper(this).executeUpdate(parameterName, inClauseObjects);
        }

        public <T> List<T> query(String inClauseParameterName, Iterable<?> inClauseObjects) {
            return new HqlInClauseBatchHelper(this).query(inClauseParameterName, inClauseObjects);
        }
    }
}

