/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import java.util.function.Function;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class StatelessDao {
    protected SessionFactory sessionFactory;

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected <T> T withStatelessSession(Function<StatelessSession, T> effect) {
        try (StatelessSession statelessSession = this.sessionFactory.openStatelessSession();){
            T t;
            Transaction tx = statelessSession.beginTransaction();
            try {
                T result = effect.apply(statelessSession);
                tx.commit();
                t = result;
            }
            catch (Exception e) {
                tx.rollback();
                throw e;
            }
            return t;
        }
    }
}

