/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5;

import com.atlassian.crowd.util.persistence.hibernate.batch.AbstractBatchProcessor;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionContract;
import org.hibernate.Transaction;

public abstract class AbstractHibernateBatchProcessor<T extends SharedSessionContract>
extends AbstractBatchProcessor<T> {
    protected final SessionFactory sessionFactory;

    public AbstractHibernateBatchProcessor(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected void afterProcessBatch() {
        this.commitTransaction();
    }

    protected void afterProcessCollection() {
        this.closeSession();
    }

    protected void afterProcessIndividual() {
        this.commitTransaction();
    }

    protected void beforeProcessBatch() {
        this.startTransaction();
    }

    protected void beforeProcessCollection() {
        this.openSession();
    }

    protected void beforeProcessIndividual() {
        this.startTransaction();
    }

    protected void rollbackProcessBatch() {
        this.rollbackTransaction();
    }

    protected void rollbackProcessIndividual() {
        this.rollbackTransaction();
    }

    protected void commitTransaction() {
        this.flushSession();
        Transaction transaction = ((SharedSessionContract)this.getSession()).getTransaction();
        this.log.debug("commit transaction [ {} ]", (Object)transaction);
        transaction.commit();
        this.clearSession();
    }

    protected void rollbackTransaction() {
        Transaction transaction = ((SharedSessionContract)this.getSession()).getTransaction();
        transaction.rollback();
        this.log.debug("rollback transaction [ {} ]", (Object)transaction);
        this.clearSession();
    }

    protected abstract void clearSession();

    protected abstract void closeSession();

    protected abstract void flushSession();

    protected abstract T openSession();

    protected void startTransaction() {
        Transaction transaction = ((SharedSessionContract)this.getSession()).beginTransaction();
        this.log.debug("start transaction [ {} ]", (Object)transaction);
    }
}

