/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5;

import com.atlassian.crowd.model.audit.AuditLogChangesetEntity;
import com.atlassian.crowd.util.persistence.hibernate.batch.SessionBatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5.AbstractHibernateBatchProcessor;
import java.util.List;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class Hibernate5BatchProcessor
extends AbstractHibernateBatchProcessor<Session>
implements SessionBatchProcessor {
    private static final ThreadLocal<Session> currentSessionHolder = new ThreadLocal();

    public Hibernate5BatchProcessor(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    protected void auditOperations(List<AuditLogChangesetEntity> changesetEntities) {
        changesetEntities.forEach(arg_0 -> ((Session)this.getSession()).merge(arg_0));
    }

    protected Session getSession() {
        return currentSessionHolder.get();
    }

    @Override
    protected void clearSession() {
        Session session = this.getSession();
        if (session != null) {
            this.log.debug("clear session [{}]", (Object)session);
            session.clear();
        }
    }

    @Override
    protected void closeSession() {
        if (currentSessionHolder.get() != null) {
            this.log.debug("close session [{}]", (Object)currentSessionHolder.get());
            currentSessionHolder.get().close();
            currentSessionHolder.set(null);
        }
    }

    @Override
    protected void flushSession() {
        Session session = this.getSession();
        if (session != null) {
            this.log.debug("flush session [{}]", (Object)session);
            session.flush();
        }
    }

    @Override
    protected Session openSession() {
        if (currentSessionHolder.get() != null) {
            throw new IllegalStateException("session already open");
        }
        Session session = this.sessionFactory.openSession();
        session.setFlushMode(FlushMode.MANUAL);
        session.setCacheMode(CacheMode.IGNORE);
        currentSessionHolder.set(session);
        this.log.debug("open new session [{}]", (Object)currentSessionHolder.get());
        return session;
    }
}

