/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate.connection;

import com.atlassian.crowd.util.persistence.hibernate.connection.DelegatingConnectionProvider;
import com.atlassian.crowd.util.persistence.hibernate.connection.jdbc.ConnectionProviderController;
import com.atlassian.crowd.util.persistence.hibernate.connection.jdbc.ConnectionTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.c3p0.internal.C3P0ConnectionProvider;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class DelegatingConnectionProviderInitiator
implements StandardServiceInitiator<ConnectionProvider>,
ConnectionProviderController {
    private final ConnectionTracker connectionTracker;
    private final ConnectionProviderInitiator delegated;
    private DelegatingConnectionProvider delegatingConnectionProvider;

    public DelegatingConnectionProviderInitiator(ConnectionTracker connectionTracker) {
        this(ConnectionProviderInitiator.INSTANCE, connectionTracker);
    }

    @VisibleForTesting
    protected DelegatingConnectionProviderInitiator(ConnectionProviderInitiator delegatedInitiator, ConnectionTracker connectionTracker) {
        this.delegated = (ConnectionProviderInitiator)Preconditions.checkNotNull((Object)delegatedInitiator, (Object)"Delegated ConnectionProviderInitiator cannot be null");
        this.connectionTracker = (ConnectionTracker)Preconditions.checkNotNull((Object)connectionTracker, (Object)"Connection Tracker cannot be null");
    }

    public ConnectionProvider initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        ConnectionProvider connectionProvider = this.delegated.initiateService(configurationValues, registry);
        if (connectionProvider instanceof C3P0ConnectionProvider) {
            this.delegatingConnectionProvider = new DelegatingConnectionProvider(connectionProvider, this.connectionTracker);
            return this.delegatingConnectionProvider;
        }
        return connectionProvider;
    }

    public Class<ConnectionProvider> getServiceInitiated() {
        return ConnectionProvider.class;
    }

    @Override
    public void restart() {
        if (this.delegatingConnectionProvider != null) {
            this.delegatingConnectionProvider.restart();
        }
    }

    @Override
    public void shutdown(String shutDownReason) {
        if (this.delegatingConnectionProvider != null) {
            this.delegatingConnectionProvider.shutdown(shutDownReason);
        }
    }
}

