/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.liquibase.ext.datatype;

import com.atlassian.crowd.util.persistence.hibernate.SQLServerIntlDialect;
import com.atlassian.crowd.util.persistence.liquibase.ext.HibernateUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import liquibase.database.Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.ClobType;
import org.hibernate.dialect.SQLServerDialect;

@DataTypeInfo(name="hclob", minParameters=0, maxParameters=0, priority=1)
public class CrowdCustomClobType
extends ClobType {
    private final HibernateUtil hibernateUtil;

    public CrowdCustomClobType() {
        this(HibernateUtil.getInstance());
    }

    @VisibleForTesting
    CrowdCustomClobType(HibernateUtil hibernateUtil) {
        this.hibernateUtil = hibernateUtil;
    }

    public DatabaseDataType toDatabaseDataType(Database database) {
        Object hibernateDialect = this.hibernateUtil.getHibernateDialect(SQLServerDialect.class.getName());
        if (database instanceof OracleDatabase) {
            return new DatabaseDataType("clob");
        }
        if (database instanceof MySQLDatabase) {
            return new DatabaseDataType("longtext");
        }
        if (database instanceof HsqlDatabase) {
            return new DatabaseDataType("longvarchar");
        }
        if (database instanceof PostgresDatabase) {
            return new DatabaseDataType("text");
        }
        if (database instanceof MSSQLDatabase) {
            if (Objects.equals(hibernateDialect, SQLServerIntlDialect.class.getName())) {
                return new DatabaseDataType("ntext");
            }
            return new DatabaseDataType("text");
        }
        throw new IllegalStateException("Unsupported database: " + String.valueOf(database));
    }
}

