/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.liquibase.ext.datatype;

import com.atlassian.crowd.util.persistence.hibernate.SQLServerIntlDialect;
import com.atlassian.crowd.util.persistence.liquibase.ext.HibernateUtil;
import com.atlassian.crowd.util.persistence.liquibase.ext.datatype.TypeWithFallbackType;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Objects;
import liquibase.change.core.LoadDataChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.NVarcharType;
import liquibase.datatype.core.VarcharType;
import org.hibernate.dialect.SQLServerDialect;

@DataTypeInfo(name="hvarchar", minParameters=1, maxParameters=1, priority=1)
public class CrowdCustomVarchar
extends TypeWithFallbackType<VarcharType> {
    private final HibernateUtil hibernateUtil;

    public CrowdCustomVarchar() {
        this(new VarcharType(), HibernateUtil.getInstance());
    }

    @VisibleForTesting
    CrowdCustomVarchar(VarcharType fallbackType, HibernateUtil hibernateUtil) {
        super(fallbackType);
        this.hibernateUtil = hibernateUtil;
    }

    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        Object hibernateDialect = this.hibernateUtil.getHibernateDialect(SQLServerDialect.class.getName());
        Object[] parameters = this.getParameters();
        if (database instanceof OracleDatabase && parameters.length == 1) {
            return new DatabaseDataType("VARCHAR2", new Object[]{String.valueOf(parameters[0]) + " char"});
        }
        if (database instanceof MSSQLDatabase && Objects.equals(hibernateDialect, SQLServerIntlDialect.class.getName())) {
            NVarcharType nVarcharType = new NVarcharType();
            Arrays.stream(parameters).forEach(arg_0 -> ((NVarcharType)nVarcharType).addParameter(arg_0));
            return nVarcharType.toDatabaseDataType(database);
        }
        return super.toDatabaseDataType(database);
    }

    public LoadDataChange.LOAD_DATA_TYPE getLoadTypeName() {
        return LoadDataChange.LOAD_DATA_TYPE.STRING;
    }
}

