/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.liquibase.ext.datatype.legacyhibernate;

import liquibase.database.Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.BlobType;

@DataTypeInfo(name="hbinary", minParameters=1, maxParameters=1, priority=1)
public class HibernateBinaryType
extends BlobType {
    public DatabaseDataType toDatabaseDataType(Database database) {
        int precision = this.getPrecision();
        if (database instanceof OracleDatabase) {
            if (precision > 2000) {
                return new DatabaseDataType("BLOB");
            }
            return new DatabaseDataType("RAW", new Object[]{precision});
        }
        if (database instanceof MSSQLDatabase) {
            if (precision > 8000) {
                return new DatabaseDataType(database.escapeDataTypeName("IMAGE"));
            }
            return new DatabaseDataType(database.escapeDataTypeName("VARBINARY"), new Object[]{precision});
        }
        if (database instanceof MySQLDatabase) {
            if (precision > 0xFFFFFF) {
                return new DatabaseDataType("LONGBLOB");
            }
            if (precision > 65535) {
                return new DatabaseDataType("MEDIUMBLOB");
            }
            if (precision > 255) {
                return new DatabaseDataType("BLOB");
            }
            return new DatabaseDataType("TINYBLOB");
        }
        if (database instanceof HsqlDatabase) {
            return new DatabaseDataType(database.escapeDataTypeName("VARBINARY"), new Object[]{precision});
        }
        if (database instanceof PostgresDatabase) {
            return new DatabaseDataType("BYTEA");
        }
        throw new IllegalStateException("Unsupported database: " + String.valueOf(database));
    }

    private int getPrecision() {
        return Integer.valueOf(String.valueOf(this.getParameters()[0]));
    }
}

