/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.liquibase.ext.precondition;

import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.executor.ExecutorService;
import liquibase.precondition.AbstractPrecondition;
import liquibase.precondition.Precondition;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSSQLIndexExistsPrecondition
extends AbstractPrecondition {
    protected static final Logger logger = LoggerFactory.getLogger(MSSQLIndexExistsPrecondition.class);
    private static final String GET_ALL_INDEXES = "SELECT COUNT(1) FROM sys.indexes si JOIN sys.objects so ON si.object_id = so.object_id WHERE so.name = '%table_name%' and si.name = '%index_name%'";
    private String tableName;
    private String indexName;

    public String getName() {
        return "mssqlIndexExists";
    }

    public Warnings warn(Database database) {
        return new Warnings();
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet, ChangeExecListener listener) throws PreconditionFailedException, PreconditionErrorException {
        logger.info("Changeset '{}': mssqlIndexExists, checking if index '{}' exists on table '{}'", new Object[]{changeSet.getId(), this.indexName, this.tableName});
        try {
            String sql = GET_ALL_INDEXES.replaceFirst("%table_name%", this.tableName).replaceFirst("%index_name%", this.indexName);
            String result = (String)((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForObject((SqlStatement)new RawSqlStatement(sql), String.class);
            if (!result.equals("1")) {
                throw new PreconditionFailedException("MS SQL custom precondition failed. Index '" + this.indexName + "' not found for table '" + this.tableName + "'", changeLog, (Precondition)this);
            }
        }
        catch (DatabaseException e) {
            throw new PreconditionErrorException((Exception)((Object)e), changeLog, (Precondition)this);
        }
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/snapshot-ext";
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }
}

