/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.vault.VaultException;
import org.springframework.vault.client.VaultResponses;
import org.springframework.vault.core.PropertyMapper;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultPkiOperations;
import org.springframework.vault.support.VaultCertificateRequest;
import org.springframework.vault.support.VaultCertificateResponse;
import org.springframework.vault.support.VaultIssuerCertificateRequestResponse;
import org.springframework.vault.support.VaultSignCertificateRequestResponse;
import org.springframework.web.client.HttpStatusCodeException;

public class VaultPkiTemplate
implements VaultPkiOperations {
    private final VaultOperations vaultOperations;
    private final String path;

    public VaultPkiTemplate(VaultOperations vaultOperations, String path) {
        Assert.notNull((Object)vaultOperations, (String)"VaultOperations must not be null");
        Assert.hasText((String)path, (String)"Path must not be empty");
        this.vaultOperations = vaultOperations;
        this.path = path;
    }

    @Override
    public VaultCertificateResponse issueCertificate(String roleName, VaultCertificateRequest certificateRequest) throws VaultException {
        Assert.hasText((String)roleName, (String)"Role name must not be empty");
        Assert.notNull((Object)certificateRequest, (String)"Certificate request must not be null");
        return this.requestCertificate(roleName, "{path}/issue/{roleName}", VaultPkiTemplate.createIssueRequest(certificateRequest), VaultCertificateResponse.class);
    }

    @Override
    public VaultSignCertificateRequestResponse signCertificateRequest(String roleName, String csr, VaultCertificateRequest certificateRequest) throws VaultException {
        Assert.hasText((String)roleName, (String)"Role name must not be empty");
        Assert.hasText((String)csr, (String)"CSR name must not be empty");
        Assert.notNull((Object)certificateRequest, (String)"Certificate request must not be null");
        Map<String, Object> body = VaultPkiTemplate.createIssueRequest(certificateRequest);
        body.put("csr", csr);
        return this.requestCertificate(roleName, "{path}/sign/{roleName}", body, VaultSignCertificateRequestResponse.class);
    }

    private <T> T requestCertificate(String roleName, String requestPath, Map<String, Object> request, Class<T> responseType) {
        request.putIfAbsent("format", "der");
        Object response = this.vaultOperations.doWithSession(restOperations -> {
            try {
                return restOperations.postForObject(requestPath, (Object)request, responseType, new Object[]{this.path, roleName});
            }
            catch (HttpStatusCodeException e) {
                throw VaultResponses.buildException(e);
            }
        });
        Assert.state((response != null ? 1 : 0) != 0, (String)"VaultCertificateResponse must not be null");
        return (T)response;
    }

    @Override
    public void revoke(String serialNumber) throws VaultException {
        Assert.hasText((String)serialNumber, (String)"Serial number must not be null or empty");
        this.vaultOperations.doWithSession(restOperations -> {
            try {
                restOperations.postForObject("{path}/revoke", Collections.singletonMap("serial_number", serialNumber), Map.class, new Object[]{this.path});
                return null;
            }
            catch (HttpStatusCodeException e) {
                throw VaultResponses.buildException(e);
            }
        });
    }

    @Override
    public InputStream getCrl(VaultPkiOperations.Encoding encoding) throws VaultException {
        Assert.notNull((Object)((Object)encoding), (String)"Encoding must not be null");
        return this.vaultOperations.doWithSession(restOperations -> {
            String requestPath = encoding == VaultPkiOperations.Encoding.DER ? "{path}/crl" : "{path}/crl/pem";
            try {
                ResponseEntity response = restOperations.getForEntity(requestPath, byte[].class, new Object[]{this.path});
                if (response.getStatusCode().is2xxSuccessful() && response.hasBody()) {
                    return new ByteArrayInputStream((byte[])response.getBody());
                }
                return null;
            }
            catch (HttpStatusCodeException e) {
                throw VaultResponses.buildException(e);
            }
        });
    }

    @Override
    public VaultIssuerCertificateRequestResponse getIssuerCertificate(String issuer) throws VaultException {
        Assert.hasText((String)issuer, (String)"Issuer must not be empty");
        return this.vaultOperations.doWithSession(restOperations -> {
            try {
                return (VaultIssuerCertificateRequestResponse)restOperations.getForObject("{path}/issuer/{issuer}/json", VaultIssuerCertificateRequestResponse.class, new Object[]{this.path, issuer});
            }
            catch (HttpStatusCodeException e) {
                throw VaultResponses.buildException(e);
            }
        });
    }

    @Override
    public InputStream getIssuerCertificate(String issuer, VaultPkiOperations.Encoding encoding) throws VaultException {
        Assert.hasText((String)issuer, (String)"Issuer must not be empty");
        Assert.notNull((Object)((Object)encoding), (String)"Encoding must not be null");
        return this.vaultOperations.doWithSession(restOperations -> {
            String requestPath = String.format("{path}/issuer/{issuer}/%s", encoding.name().toLowerCase(Locale.ROOT));
            try {
                ResponseEntity response = restOperations.getForEntity(requestPath, byte[].class, new Object[]{this.path, issuer});
                if (response.getStatusCode().is2xxSuccessful() && response.hasBody()) {
                    return new ByteArrayInputStream((byte[])response.getBody());
                }
                return null;
            }
            catch (HttpStatusCodeException e) {
                throw VaultResponses.buildException(e);
            }
        });
    }

    private static Map<String, Object> createIssueRequest(VaultCertificateRequest certificateRequest) {
        Assert.notNull((Object)certificateRequest, (String)"Certificate request must not be null");
        HashMap<String, Object> request = new HashMap<String, Object>();
        PropertyMapper mapper = PropertyMapper.get();
        mapper.from(certificateRequest::getCommonName).to("common_name", request);
        mapper.from(certificateRequest::getAltNames).whenNotEmpty().as(i -> StringUtils.collectionToDelimitedString((Collection)i, (String)",")).to("alt_names", request);
        mapper.from(certificateRequest::getIpSubjectAltNames).whenNotEmpty().as(i -> StringUtils.collectionToDelimitedString((Collection)i, (String)",")).to("ip_sans", request);
        mapper.from(certificateRequest::getUriSubjectAltNames).whenNotEmpty().as(i -> StringUtils.collectionToDelimitedString((Collection)i, (String)",")).to("uri_sans", request);
        mapper.from(certificateRequest::getOtherSans).whenNotEmpty().as(i -> StringUtils.collectionToDelimitedString((Collection)i, (String)",")).to("other_sans", request);
        mapper.from(certificateRequest::getTtl).whenNonNull().as(i -> i.get(ChronoUnit.SECONDS)).to("ttl", request);
        mapper.from(certificateRequest::isExcludeCommonNameFromSubjectAltNames).whenTrue().to("exclude_cn_from_sans", request);
        mapper.from(certificateRequest::getFormat).whenHasText().to("format", request);
        mapper.from(certificateRequest::getPrivateKeyFormat).whenHasText().to("private_key_format", request);
        mapper.from(certificateRequest::getNotAfter).whenHasText().as(Instant::toString).to("not_after", request);
        mapper.from(certificateRequest::getUserIds).whenHasText().to("user_ids", request);
        return request;
    }
}

