/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.accounts.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.sal.api.ApplicationProperties;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class ServiceAccountEventFactory {
    private final ApplicationProperties applicationProperties;

    public ServiceAccountEventFactory(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public ServiceAccountCreationEvent createCreateEvent() {
        return new ServiceAccountCreationEvent(this.applicationProperties.getPlatformId());
    }

    public ServiceAccountGetEvent createGetEvent() {
        return new ServiceAccountGetEvent(this.applicationProperties.getPlatformId());
    }

    public ServiceAccountGetAllActiveEvent createGetAllActiveEvent(int activeServiceAccountsCount) {
        return new ServiceAccountGetAllActiveEvent(this.applicationProperties.getPlatformId(), activeServiceAccountsCount);
    }

    @EventName(value="serviceaccounts.created")
    private static class ServiceAccountCreationEvent {
        @Nonnull
        private final String product;

        private ServiceAccountCreationEvent(@Nonnull String product) {
            this.product = Objects.requireNonNull(product, "product can't be null");
        }

        @Nonnull
        public String getProduct() {
            return this.product;
        }
    }

    @EventName(value="serviceaccounts.obtained")
    private static class ServiceAccountGetEvent {
        @Nonnull
        private final String product;

        private ServiceAccountGetEvent(@Nonnull String product) {
            this.product = Objects.requireNonNull(product, "product can't be null");
        }

        @Nonnull
        public String getProduct() {
            return this.product;
        }
    }

    @EventName(value="serviceaccounts.allactive")
    private static class ServiceAccountGetAllActiveEvent {
        @Nonnull
        private final String product;
        private final int activeServiceAccountsCount;

        private ServiceAccountGetAllActiveEvent(@Nonnull String product, int activeServiceAccountsCount) {
            this.product = Objects.requireNonNull(product, "product can't be null");
            this.activeServiceAccountsCount = activeServiceAccountsCount;
        }

        @Nonnull
        public String getProduct() {
            return this.product;
        }

        public int getActiveServiceAccountsCount() {
            return this.activeServiceAccountsCount;
        }
    }
}

