/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.accounts.configuration;

import com.atlassian.crowd.embedded.api.service.ServiceAccountAuthService;
import com.atlassian.crowd.embedded.api.service.ServiceAccountManager;
import com.atlassian.crowd.embedded.spi.service.RestrictedResourcesProvider;
import com.atlassian.crowd.service.accounts.analytics.ServiceAccountEventFactory;
import com.atlassian.crowd.service.accounts.rest.ServiceAccountResource;
import com.atlassian.crowd.service.accounts.rest.ServiceAccountRestService;
import com.atlassian.crowd.service.accounts.rest.entities.ServiceAccountValidator;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.oauth2.provider.api.client.ClientExpirationEvaluator;
import com.atlassian.oauth2.provider.api.client.ClientService;
import com.atlassian.oauth2.provider.api.external.OAuth2ProviderService;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ServiceAccountsConfiguration {
    @Bean
    public ServiceAccountManager serviceAccountManager() {
        return OsgiServices.importOsgiService(ServiceAccountManager.class);
    }

    @Bean
    public RestrictedResourcesProvider restrictedResourcesProvider() {
        return OsgiServices.importOsgiService(RestrictedResourcesProvider.class);
    }

    @Bean
    public ServiceAccountAuthService serviceAccountAuthService() {
        return OsgiServices.importOsgiService(ServiceAccountAuthService.class);
    }

    @Bean
    public SoyTemplateRenderer soyTemplateRenderer() {
        return OsgiServices.importOsgiService(SoyTemplateRenderer.class);
    }

    @Bean
    public LoginUriProvider loginUriProvider() {
        return OsgiServices.importOsgiService(LoginUriProvider.class);
    }

    @Bean
    public WebSudoManager webSudoManager() {
        return OsgiServices.importOsgiService(WebSudoManager.class);
    }

    @Bean
    public PermissionEnforcer permissionEnforcer() {
        return OsgiServices.importOsgiService(PermissionEnforcer.class);
    }

    @Bean
    public UserManager userManager() {
        return OsgiServices.importOsgiService(UserManager.class);
    }

    @Bean
    public ClientExpirationEvaluator clientExpirationEvaluator() {
        return OsgiServices.importOsgiService(ClientExpirationEvaluator.class);
    }

    @Bean
    public ClientService clientService() {
        return OsgiServices.importOsgiService(ClientService.class);
    }

    @Bean
    public ScopeResolver scopeResolver() {
        return OsgiServices.importOsgiService(ScopeResolver.class);
    }

    @Bean
    public OAuth2ProviderService oAuth2ProviderService() {
        return OsgiServices.importOsgiService(OAuth2ProviderService.class);
    }

    @Bean
    public ServiceAccountRestService serviceAccountRestService() {
        return new ServiceAccountRestService(this.clientService(), this.scopeResolver(), this.serviceAccountManager(), this.serviceAccountAuthService(), this.restrictedResourcesProvider(), this.clientExpirationEvaluator(), this.oAuth2ProviderService(), this.userManager());
    }

    @Bean
    public EventPublisher eventPublisher() {
        return OsgiServices.importOsgiService(EventPublisher.class);
    }

    @Bean
    public ServiceAccountEventFactory serviceAccountEventFactory() {
        return new ServiceAccountEventFactory(this.applicationProperties());
    }

    @Bean
    public ServiceAccountValidator serviceAccountValidator() {
        return new ServiceAccountValidator(this.i18nResolver());
    }

    @Bean
    public ServiceAccountResource serviceAccountResource() {
        return new ServiceAccountResource(this.serviceAccountRestService(), this.eventPublisher(), this.serviceAccountEventFactory(), this.serviceAccountValidator());
    }

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        return mapper;
    }

    @Bean
    public TimeZoneManager timeZoneManager() {
        return OsgiServices.importOsgiService(TimeZoneManager.class);
    }

    @Bean
    public LocaleResolver localeResolver() {
        return OsgiServices.importOsgiService(LocaleResolver.class);
    }

    @Bean
    public HelpPathResolver helpPathResolver() {
        return OsgiServices.importOsgiService(HelpPathResolver.class);
    }

    @Bean
    public ApplicationProperties applicationProperties() {
        return OsgiServices.importOsgiService(ApplicationProperties.class);
    }

    @Bean
    public I18nResolver i18nResolver() {
        return OsgiServices.importOsgiService(I18nResolver.class);
    }
}

