/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.accounts.data;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.crowd.service.accounts.data.ServiceAccountsKbArticleData;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.HelpPath;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@Nonnull
public class ServiceAccountsKbArticleDataProvider
implements WebResourceDataProvider {
    @VisibleForTesting
    static final String HELP_PREFIX = "help.";
    @VisibleForTesting
    static final String FALLBACK_URL = "https://www.atlassian.com/";
    private static final String KB_ARTICLES_PROPERTIES_FILE_PATH = "/atlassian-sa-kb-articles.properties";
    private static final String PREFIX_KEY = "help.atlassian.sa.frontend.kb.";
    private static final String KB_FEATURE_KEY = "help.atlassian.sa.frontend.kb.feature";
    private static final String KB_SCOPES_KEY = "help.atlassian.sa.frontend.kb.scopes";
    private final ApplicationProperties applicationProperties;
    private final HelpPathResolver helpPathResolver;
    private final ObjectMapper objectMapper;
    private final Properties kbArticles;

    public ServiceAccountsKbArticleDataProvider(ApplicationProperties applicationProperties, HelpPathResolver helpPathResolver, ObjectMapper objectMapper) {
        this(applicationProperties, helpPathResolver, objectMapper, () -> {
            Properties properties = new Properties();
            try {
                properties.load(ServiceAccountsKbArticleDataProvider.class.getResourceAsStream(KB_ARTICLES_PROPERTIES_FILE_PATH));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return properties;
        });
    }

    @VisibleForTesting
    ServiceAccountsKbArticleDataProvider(ApplicationProperties applicationProperties, HelpPathResolver helpPathResolver, ObjectMapper objectMapper, Supplier<Properties> properties) {
        this.applicationProperties = applicationProperties;
        this.helpPathResolver = helpPathResolver;
        this.objectMapper = objectMapper;
        this.kbArticles = properties.get();
    }

    public Jsonable get() {
        return writer -> {
            try {
                this.objectMapper.writeValue(writer, (Object)this.getData());
            }
            catch (Exception e) {
                throw new JsonMappingException(e.getMessage(), (Throwable)e);
            }
        };
    }

    @VisibleForTesting
    ServiceAccountsKbArticleData getData() {
        return new ServiceAccountsKbArticleData(URI.create(this.getHelpPathForProduct(KB_FEATURE_KEY)), URI.create(this.getHelpPathForProduct(KB_SCOPES_KEY)));
    }

    @VisibleForTesting
    String getHelpPathForProduct(String helpPathKey) {
        String productHelpPathKey = helpPathKey + "." + this.applicationProperties.getPlatformId();
        return Optional.ofNullable(this.helpPathResolver.getHelpPath(productHelpPathKey)).map(HelpPath::getUrl).orElse(FALLBACK_URL);
    }
}

