/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.accounts.rest;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.crowd.embedded.api.Page;
import com.atlassian.crowd.embedded.api.PageRequest;
import com.atlassian.crowd.embedded.spi.service.RestrictedResourcesProvider;
import com.atlassian.crowd.search.PageRequestImpl;
import com.atlassian.crowd.service.accounts.rest.entities.PageDto;
import com.atlassian.crowd.service.accounts.rest.entities.ResourceDto;
import com.atlassian.crowd.service.accounts.rest.entities.ResourceTypeDto;
import com.atlassian.crowd.service.accounts.rest.mappers.ResourceMapper;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/resources")
@Produces(value={"application/json"})
@SystemAdminOnly
@ExperimentalApi
public class ServiceAccountResourceResource {
    private static final Logger logger = LoggerFactory.getLogger(ServiceAccountResourceResource.class);
    private final RestrictedResourcesProvider restrictedResourcesProvider;
    private final I18nResolver i18nResolver;

    @Inject
    public ServiceAccountResourceResource(RestrictedResourcesProvider restrictedResourcesProvider, I18nResolver i18nResolver) {
        this.restrictedResourcesProvider = restrictedResourcesProvider;
        this.i18nResolver = i18nResolver;
    }

    @GET
    public PageDto<ResourceDto> getAvailableResources(@QueryParam(value="resource-type-id") @DefaultValue(value="") String resourceTypeId, @QueryParam(value="query") @DefaultValue(value="") String query, @QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit) {
        logger.debug("Getting resources with query {} and limit {}", (Object)query, (Object)limit);
        Page resources = this.restrictedResourcesProvider.findResources(resourceTypeId, query, (PageRequest)new PageRequestImpl(start, limit));
        return new PageDto<ResourceDto>(resources.start(), resources.limit(), resources.isLastPage(), ResourceMapper.toResourceDtos(resources.results()));
    }

    @GET
    @Path(value="/types")
    public PageDto<ResourceTypeDto> getResourceTypes() {
        logger.debug("Getting all resource types");
        List<ResourceTypeDto> resourceTypes = this.restrictedResourcesProvider.getAllResourceTypes().stream().map(description -> ResourceMapper.toResourceTypeDto(description, this.i18nResolver)).toList();
        return new PageDto<ResourceTypeDto>(0, resourceTypes.size(), true, resourceTypes);
    }
}

