/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.accounts.rest.mappers;

import com.atlassian.crowd.embedded.api.service.Resource;
import com.atlassian.crowd.embedded.api.service.ResourceType;
import com.atlassian.crowd.embedded.api.service.ServiceAccount;
import com.atlassian.crowd.embedded.spi.service.ResourceTypeDescription;
import com.atlassian.crowd.embedded.spi.service.RestrictedResourcesProvider;
import com.atlassian.crowd.model.service.ServiceAccountImpl;
import com.atlassian.crowd.service.accounts.rest.entities.ResourceDto;
import com.atlassian.crowd.service.accounts.rest.entities.ServiceAccountCreateDto;
import com.atlassian.crowd.service.accounts.rest.entities.ServiceAccountUpdateDto;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class ServiceAccountMapper {
    private ServiceAccountMapper() {
    }

    public static ServiceAccount toServiceAccount(ServiceAccountCreateDto dto, RestrictedResourcesProvider restrictedResourcesProvider) {
        return new ServiceAccountImpl.Builder(null).active(true).displayName(dto.displayName()).description(dto.description()).resourceRestrictions(ServiceAccountMapper.mapResourceRestrictions(dto.resourceRestrictions(), restrictedResourcesProvider)).build();
    }

    public static ServiceAccount toServiceAccount(ServiceAccountUpdateDto serviceAccountUpdateDto, ServiceAccount existingServiceAccount, RestrictedResourcesProvider restrictedResourcesProvider) {
        return new ServiceAccountImpl.Builder(existingServiceAccount.getName()).id(existingServiceAccount.getId()).active(existingServiceAccount.isActive()).displayName(serviceAccountUpdateDto.getDisplayName()).description(serviceAccountUpdateDto.getDescription()).resourceRestrictions(ServiceAccountMapper.mapResourceRestrictions(serviceAccountUpdateDto.getResourceRestrictions(), restrictedResourcesProvider)).build();
    }

    private static Map<ResourceType, Set<Resource>> mapResourceRestrictions(Set<ResourceDto> resourceRestrictionsDto, RestrictedResourcesProvider restrictedResourcesProvider) {
        Map<String, ResourceType> resourceTypes = restrictedResourcesProvider.getAllResourceTypes().stream().collect(Collectors.toMap(typeDescription -> typeDescription.getResourceType().getId(), ResourceTypeDescription::getResourceType));
        return ServiceAccountMapper.mapDtosToType(restrictedResourcesProvider, resourceRestrictionsDto, resourceTypes);
    }

    private static Map<ResourceType, Set<Resource>> mapDtosToType(RestrictedResourcesProvider restrictedResourcesProvider, Set<ResourceDto> resourceRestrictionsDto, Map<String, ? extends ResourceType> resourceTypes) {
        Map<ResourceType, Set<Object>> resourceRestrictions = new HashMap<ResourceType, Set<Resource>>();
        if (resourceRestrictionsDto != null) {
            resourceRestrictions = resourceRestrictionsDto.stream().map(resourceDto -> {
                String resourceId = resourceDto.getId();
                String resourceTypeId = resourceDto.getTypeId();
                Resource resource = restrictedResourcesProvider.getResource(resourceTypeId, resourceId).getResource();
                ResourceType resourceType = (ResourceType)resourceTypes.get(resourceTypeId);
                return Map.entry(resource, resourceType);
            }).collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
        }
        return resourceRestrictions;
    }
}

