/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.denormalisedpermissions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.permission.AuthorisationException;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;

@AnonymousSiteAccess
@WebSudoRequired
public class FrontendServlet
extends HttpServlet {
    private static final String RESOURCE_KEY = "com.atlassian.confluence.plugins.confluence-denormalised-permissions:confluence-denormalised-permissions-soy-resources";
    private static final String TEMPLATE_KEY = "confluence.denormalised.permissions.root";
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;

    @Autowired
    public FrontendServlet(@ComponentImport SoyTemplateRenderer soyTemplateRenderer, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, SoyException {
        UserKey user = this.userManager.getRemoteUserKey();
        if (user == null) {
            this.redirectToLogin(request, response);
            return;
        }
        if (!this.userManager.isAdmin(user)) {
            throw new AuthorisationException();
        }
        this.soyTemplateRenderer.render((Appendable)response.getWriter(), RESOURCE_KEY, TEMPLATE_KEY, Collections.emptyMap());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URI uri = this.getUri(request);
        response.sendRedirect(this.loginUriProvider.getLoginUri(uri).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        if (request.getQueryString() != null) {
            requestURL.append("?").append(request.getQueryString());
        }
        return URI.create(requestURL.toString());
    }
}

