/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.denormalisedpermissions.rest;

import com.atlassian.confluence.plugins.denormalisedpermissions.state.ServiceStateJson;
import com.atlassian.confluence.security.denormalisedpermissions.DenormalisedPermissionServiceState;
import com.atlassian.confluence.security.denormalisedpermissions.DenormalisedPermissionStateManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Path(value="/")
@AdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DenormalisedPermissionsResource {
    private final DenormalisedPermissionStateManager denormalisedPermissionStateManager;

    @Inject
    public DenormalisedPermissionsResource(@ComponentImport DenormalisedPermissionStateManager denormalisedPermissionStateManager) {
        this.denormalisedPermissionStateManager = denormalisedPermissionStateManager;
    }

    @GET
    @Path(value="/state")
    public Response getState(@QueryParam(value="logLimit") int logLimit) {
        DenormalisedPermissionServiceState spaceServiceState = this.denormalisedPermissionStateManager.getSpaceServiceState(true);
        DenormalisedPermissionServiceState contentServiceState = this.denormalisedPermissionStateManager.getContentServiceState(true);
        Long spaceLag = this.denormalisedPermissionStateManager.getSpacePermissionUpdateLag();
        Long contentLag = this.denormalisedPermissionStateManager.getContentPermissionUpdateLag();
        List stateChangeLog = this.denormalisedPermissionStateManager.getStateChangeLog(logLimit);
        return Response.ok((Object)new ServiceStateJson(spaceServiceState, contentServiceState, spaceLag, contentLag, stateChangeLog)).build();
    }

    @POST
    @Path(value="/enableservice")
    public Response enableService() {
        this.denormalisedPermissionStateManager.enableService();
        return Response.ok().build();
    }

    @POST
    @Path(value="/disableservice")
    public Response disableService(@QueryParam(value="cleanDenormalisedData") boolean cleanDenormalisedData) {
        this.denormalisedPermissionStateManager.disableService(cleanDenormalisedData);
        return Response.ok().build();
    }
}

