/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity.allowlist.impl.internal;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.velocity.allowlist.api.internal.PluginAllowlist;
import com.atlassian.velocity.allowlist.descriptor.VelocityAllowlistModuleDescriptor;
import com.atlassian.velocity.allowlist.uberspect.PluginAwareSecureIntrospector;
import com.atlassian.velocity.allowlist.util.AllowlistElements;
import com.atlassian.velocity.allowlist.util.ClassExtractor;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import jakarta.annotation.Nullable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.felix.framework.BundleWiringImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginAllowlistConfigurator
implements PluginAllowlist {
    private static final Logger LOG = LoggerFactory.getLogger(PluginAllowlistConfigurator.class);
    private final ClassExtractor classExtractor;
    private final Supplier<PluginAccessor> pluginAccessorRef;
    private final ResettableLazyReference<Map<Class<?>, Set<String>>> pluginAllowlistedMethods = Lazy.resettable(this::constructPluginMethodAllowlist);
    private final ResettableLazyReference<Set<Class<?>>> pluginAllowlistedClasses = Lazy.resettable(this::constructPluginClassAllowlist);
    private final ResettableLazyReference<Map<String, Set<String>>> pluginAllowlistedPackagesBySymbolicName = Lazy.resettable(this::constructPluginPackageAllowlist);

    @Deprecated(forRemoval=true)
    public PluginAllowlistConfigurator() {
        this(new ClassExtractor(), Lazy.supplier(() -> (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor", PluginAccessor.class)));
    }

    public PluginAllowlistConfigurator(PluginAccessor pluginAccessor) {
        this(new ClassExtractor(), () -> pluginAccessor);
    }

    @VisibleForTesting
    PluginAllowlistConfigurator(ClassExtractor classExtractor, Supplier<PluginAccessor> pluginAccessorRef) {
        this.classExtractor = classExtractor;
        this.pluginAccessorRef = pluginAccessorRef;
    }

    @Override
    public void reload() {
        this.pluginAllowlistedMethods.reset();
        this.pluginAllowlistedClasses.reset();
        this.pluginAllowlistedPackagesBySymbolicName.reset();
    }

    @Override
    public boolean isAllowlistedClassPackage(Class<?> clazz) {
        return ((Set)this.pluginAllowlistedClasses.get()).contains(clazz) || this.isPackageAllowlisted(clazz);
    }

    @Override
    public boolean isAllowlistedMethod(Method method) {
        Set methodAllowlist = (Set)((Map)this.pluginAllowlistedMethods.get()).get(method.getDeclaringClass());
        return methodAllowlist != null && methodAllowlist.contains(PluginAwareSecureIntrospector.toMethodStr(method));
    }

    private boolean isPackageAllowlisted(Class<?> clazz) {
        ClassLoader classLoader = this.classExtractor.extractClassLoader(clazz);
        if (!(classLoader instanceof BundleWiringImpl.BundleClassLoader)) {
            return false;
        }
        String symbolicName = this.classExtractor.extractPluginBundle(classLoader).getSymbolicName();
        Set allowedPackages = (Set)((Map)this.pluginAllowlistedPackagesBySymbolicName.get()).get(symbolicName);
        return allowedPackages != null && PluginAllowlistConfigurator.isPackageMatches(this.classExtractor.extractPackage(clazz), allowedPackages);
    }

    private static String toPackageName(Package packag) {
        return packag != null ? packag.getName() : "";
    }

    private static boolean isPackageMatches(Package packag, Set<String> matchingPackages) {
        List<String> packageParts = Arrays.asList(PluginAllowlistConfigurator.toPackageName(packag).split("\\."));
        return IntStream.range(0, packageParts.size()).mapToObj(i -> String.join((CharSequence)".", packageParts.subList(0, i + 1))).anyMatch(matchingPackages::contains);
    }

    private Map<Class<?>, Set<String>> constructPluginMethodAllowlist() {
        List<VelocityAllowlistModuleDescriptor> allowlistModules = this.getModuleDescriptors();
        HashMap methodAllowlist = new HashMap();
        for (VelocityAllowlistModuleDescriptor module : allowlistModules) {
            Map<Class<?>, Set<String>> moduleAllowlist = this.getModuleMethodAllowlist(module);
            if (moduleAllowlist == null) {
                module.disabled();
                continue;
            }
            PluginAllowlistConfigurator.putAllAndMerge(methodAllowlist, moduleAllowlist);
        }
        methodAllowlist.keySet().forEach(clazz -> methodAllowlist.put(clazz, Collections.unmodifiableSet((Set)methodAllowlist.get(clazz))));
        return Collections.unmodifiableMap(methodAllowlist);
    }

    @Nullable
    private Map<Class<?>, Set<String>> getModuleMethodAllowlist(VelocityAllowlistModuleDescriptor module) {
        HashMap moduleAllowlist = new HashMap();
        AllowlistElements parser = module.getAllowlistElements();
        for (Map.Entry<String, Set<String>> entry : parser.getMethods().entrySet()) {
            Class clazz;
            String clazzName = entry.getKey();
            Set<String> methodNames = entry.getValue();
            try {
                clazz = module.getPlugin().loadClass(clazzName, this.getClass());
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Class {} cannot be loaded - disabling Velocity Allowlist plugin module {}}", (Object)clazzName, (Object)module.getCompleteKey());
                return null;
            }
            Collection<String> invalidMethods = PluginAllowlistConfigurator.toInvalidMethods(clazz, methodNames);
            if (!invalidMethods.isEmpty()) {
                LOG.warn("Invalid method(s) {} defined for class {} - disabling Velocity Allowlist plugin module {}", new Object[]{String.join((CharSequence)", ", invalidMethods), clazz.getName(), module.getCompleteKey()});
                return null;
            }
            moduleAllowlist.put(clazz, methodNames);
        }
        return moduleAllowlist;
    }

    private static Collection<String> toInvalidMethods(Class<?> clazz, Set<String> methods) {
        Set declMethods = Arrays.stream(clazz.getDeclaredMethods()).map(PluginAwareSecureIntrospector::toMethodStr).collect(Collectors.toSet());
        return methods.stream().filter(method -> !declMethods.contains(method)).toList();
    }

    private Set<Class<?>> constructPluginClassAllowlist() {
        List<VelocityAllowlistModuleDescriptor> allowlistModules = this.getModuleDescriptors();
        HashSet classAllowlist = new HashSet();
        block2: for (VelocityAllowlistModuleDescriptor module : allowlistModules) {
            AllowlistElements parser = module.getAllowlistElements();
            HashSet<Class> moduleAllowlist = new HashSet<Class>();
            if (!PluginAllowlistConfigurator.isAtlassianModule(module)) continue;
            for (String className : parser.getClasses()) {
                try {
                    moduleAllowlist.add(module.getPlugin().loadClass(className, this.getClass()));
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Class {} cannot be loaded - disabling Velocity Allowlist plugin module {}", (Object)className, (Object)module.getCompleteKey());
                    module.disabled();
                    continue block2;
                }
            }
            classAllowlist.addAll(moduleAllowlist);
        }
        return Collections.unmodifiableSet(classAllowlist);
    }

    private Map<String, Set<String>> constructPluginPackageAllowlist() {
        List<VelocityAllowlistModuleDescriptor> allowlistModules = this.getModuleDescriptors();
        HashMap packageAllowlist = new HashMap();
        for (VelocityAllowlistModuleDescriptor module : allowlistModules) {
            String symbolicName;
            Set<String> packages;
            AllowlistElements parser = module.getAllowlistElements();
            if (!PluginAllowlistConfigurator.isAtlassianModule(module) || (packages = parser.getPackages()).isEmpty()) continue;
            try {
                symbolicName = PluginAllowlistConfigurator.extractSymbolicNameIfP2(module.getPlugin());
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Cannot allowlist package if plugin {} is not backed by an OSGi bundle - disabling Velocity Allowlist plugin module {}", (Object)module.getPlugin().getKey(), (Object)module.getCompleteKey());
                module.disabled();
                continue;
            }
            PluginAllowlistConfigurator.putAllAndMerge(packageAllowlist, Map.of(symbolicName, packages));
        }
        return Collections.unmodifiableMap(packageAllowlist);
    }

    private static String extractSymbolicNameIfP2(Plugin plugin) throws IllegalArgumentException {
        String classLoader = plugin.getClassLoader().toString();
        String tempName = classLoader.substring(classLoader.indexOf("bundle=") + "bundle=".length());
        List<String> parsedParts = Arrays.stream(tempName.split("\\s+")).toList();
        if (parsedParts.size() != 2 || parsedParts.get(0).isEmpty()) {
            throw new IllegalArgumentException();
        }
        return parsedParts.get(0);
    }

    private static boolean isAtlassianModule(ModuleDescriptor<?> module) {
        return module.getPlugin().getPluginInformation().getVendorName().startsWith("Atlassian");
    }

    private static <S, T> void putAllAndMerge(Map<S, Set<T>> target, Map<S, Set<T>> source) {
        source.forEach((key, value) -> {
            target.putIfAbsent(key, new HashSet());
            ((Set)target.get(key)).addAll(value);
        });
    }

    private List<VelocityAllowlistModuleDescriptor> getModuleDescriptors() {
        return this.pluginAccessorRef.get().getEnabledModuleDescriptorsByClass(VelocityAllowlistModuleDescriptor.class).stream().filter(AbstractModuleDescriptor::isEnabled).toList();
    }
}

