/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.jira;

import com.atlassian.confluence.extra.jira.api.services.JiraIssuesSettingsManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class DefaultJiraIssuesSettingsManager
implements JiraIssuesSettingsManager {
    private static final String PLUGIN_SETTINGS_KEY_COLUMN_MAPPING = "com.atlassian.confluence.extra.jira:customFieldsFor:";
    private static final String PLUGIN_SETTINGS_KEY_ICON_MAPPING = "atlassian.confluence.jira.icon.mappings";
    private final PluginSettings globalPluginSettings;

    public DefaultJiraIssuesSettingsManager(PluginSettingsFactory pluginSettingsFactory) {
        this.globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    private static String getColumnMapPluginSettingsKey(String jiraIssuesUrl) {
        return PLUGIN_SETTINGS_KEY_COLUMN_MAPPING + DigestUtils.md5Hex((String)jiraIssuesUrl);
    }

    @Override
    public Map<String, String> getColumnMap(String jiraIssuesUrl) {
        return (Map)this.globalPluginSettings.get(DefaultJiraIssuesSettingsManager.getColumnMapPluginSettingsKey(jiraIssuesUrl));
    }

    @Override
    public void setColumnMap(String jiraIssuesUrl, Map<String, String> columnMapping) {
        this.globalPluginSettings.put(DefaultJiraIssuesSettingsManager.getColumnMapPluginSettingsKey(jiraIssuesUrl), new HashMap<String, String>(columnMapping));
    }

    @Override
    public Map<String, String> getIconMapping() {
        return (Map)this.globalPluginSettings.get(PLUGIN_SETTINGS_KEY_ICON_MAPPING);
    }

    @Override
    public void setIconMapping(Map<String, String> iconMapping) {
        this.globalPluginSettings.put(PLUGIN_SETTINGS_KEY_ICON_MAPPING, new HashMap<String, String>(iconMapping));
    }
}

